/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz;

import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.rpd.AuthzDefender;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.commons.util.TimeUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class AuHelper {
    private static final AuthzDefender auDefender;
    private static final UserDevicesDict userDevicesDict;
    private static final PermissionDict permissionDict;
    private static final Cache cache;

    @Nullable
    public static TokenPair login(@NonNull Object userId, @NonNull String deviceType) {
        return AuHelper.login(userId, deviceType, null);
    }

    @Nullable
    public static TokenPair login(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        return auDefender.grant(userId, deviceType, deviceId);
    }

    public static TokenPair refreshToken(@NonNull String refreshToken) {
        return auDefender.refreshToken(refreshToken);
    }

    public static Map<Object, List<Device>> listAllUsersDevices() {
        HashMap<Object, List<Device>> map = new HashMap<Object, List<Device>>();
        for (Object userId : AuHelper.listUserId()) {
            Device[] devices = AuHelper.listDeviceByUserId(userId);
            if (devices == null) continue;
            map.put(userId, Arrays.asList(devices));
        }
        return map;
    }

    public static Device[] listDevicesForCurrentUser() {
        return userDevicesDict.listDevicesForCurrentUser();
    }

    public static void removeUserById(Object userId) {
        userDevicesDict.removeAllDeviceByUserId(userId);
    }

    public static void removeUserByDeviceId(Object userId, String deviceId) {
        userDevicesDict.removeDeviceByUserIdAndDeviceId(userId, deviceId);
    }

    public static void removeUserByDeviceType(Object userId, String deviceType) {
        userDevicesDict.removeDeviceByUserIdAndDeviceType(userId, deviceType);
    }

    public static Object[] listUserId() {
        return userDevicesDict.listUserId();
    }

    public static Device[] listDeviceByUserId(Object userId) {
        return userDevicesDict.listDevicesByUserId(userId);
    }

    public static PermRolesMeta operatePermRolesMeta(PermRolesMeta.Vo permRolesMetaVo) {
        return permissionDict.modify(permRolesMetaVo);
    }

    public static void reloadCache() {
        cache.reload();
    }

    public static boolean checkUserIsActive(Object userId) {
        return userDevicesDict.listActiveUserDevices(userId, 60000L).length > 0;
    }

    public static boolean checkUserIsActive(Object userId, String time) {
        return userDevicesDict.listActiveUserDevices(userId, TimeUtils.parseTimeValue((String)time)).length > 0;
    }

    public static int getActiveUsersNumbers() {
        return userDevicesDict.listActiveUsers(60000L).length;
    }

    public static int getActiveUsersNumbers(String time) {
        return userDevicesDict.listActiveUsers(TimeUtils.parseTimeValue((String)time)).length;
    }

    public static Object[] listActiveUsers() {
        return userDevicesDict.listActiveUsers(60000L);
    }

    public static Object[] listActiveUsers(String time) {
        return userDevicesDict.listActiveUsers(TimeUtils.parseTimeValue((String)time));
    }

    private AuHelper() {
    }

    static {
        userDevicesDict = AUtils.getBean(UserDevicesDict.class);
        permissionDict = PermissionDict.self();
        auDefender = AUtils.getBean(AuthzDefender.class);
        cache = AUtils.getBean(Cache.class);
    }
}

