/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtils.class);
    public static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    public static final String INCLUDE_QUERY_STRING_ATTRIBUTE = "javax.servlet.include.query_string";
    public static final String FORWARD_REQUEST_URI_ATTRIBUTE = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.forward.context_path";
    public static final String FORWARD_SERVLET_PATH_ATTRIBUTE = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_PATH_INFO_ATTRIBUTE = "javax.servlet.forward.path_info";
    public static final String FORWARD_QUERY_STRING_ATTRIBUTE = "javax.servlet.forward.query_string";
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";

    public static String getPathWithinApplication(HttpServletRequest request) {
        String contextPath = WebUtils.getContextPath(request);
        String requestUri = WebUtils.getRequestUri(request);
        if (StringUtils.startsWithIgnoreCase((CharSequence)requestUri, (CharSequence)contextPath)) {
            String path = requestUri.substring(contextPath.length());
            return StringUtils.isNotBlank((CharSequence)path) ? path : "/";
        }
        return requestUri;
    }

    public static String getRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE);
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return WebUtils.normalize(WebUtils.decodeAndCleanUriString(request, uri));
    }

    public static String normalize(String path) {
        return WebUtils.normalize(path, true);
    }

    private static String normalize(String path, boolean replaceBackSlash) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (replaceBackSlash && normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    private static String decodeAndCleanUriString(HttpServletRequest request, String uri) {
        int semicolonIndex = (uri = WebUtils.decodeRequestString(request, uri)).indexOf(59);
        return semicolonIndex != -1 ? uri.substring(0, semicolonIndex) : uri;
    }

    public static String getContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute(INCLUDE_CONTEXT_PATH_ATTRIBUTE);
        if (contextPath == null) {
            contextPath = request.getContextPath();
        }
        if ("/".equals(contextPath = WebUtils.normalize(WebUtils.decodeRequestString(request, contextPath)))) {
            contextPath = "";
        }
        return contextPath;
    }

    public static String decodeRequestString(HttpServletRequest request, String source) {
        String enc = WebUtils.determineEncoding(request);
        try {
            return URLDecoder.decode(source, enc);
        }
        catch (UnsupportedEncodingException ex) {
            if (log.isWarnEnabled()) {
                log.warn("Could not decode request string [" + source + "] with encoding '" + enc + "': falling back to platform default encoding; exception message: " + ex.getMessage());
            }
            return URLDecoder.decode(source);
        }
    }

    protected static String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = DEFAULT_CHARACTER_ENCODING;
        }
        return enc;
    }

    public static HttpServletRequest toHttp(ServletRequest request) {
        return (HttpServletRequest)request;
    }

    public static HttpServletResponse toHttp(ServletResponse response) {
        return (HttpServletResponse)response;
    }

    public static String getCleanParam(ServletRequest request, String paramName) {
        return WebUtils.clean(request.getParameter(paramName));
    }

    private static String clean(String in) {
        String out = in;
        if (in != null && (out = in.trim()).equals("")) {
            out = null;
        }
        return out;
    }

    public static String removeParam(String queryString, String name) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return "";
        }
        Pattern compile = Pattern.compile("(?i)" + name + "=[^&]*&?");
        Matcher matcher = compile.matcher(queryString);
        while (matcher.find()) {
            queryString = matcher.replaceFirst("");
            matcher.reset(queryString);
        }
        queryString = StringUtils.removeEnd((String)queryString, (String)"&");
        return StringUtils.isNotBlank((CharSequence)(queryString = StringUtils.removeStart((String)queryString, (String)"?"))) ? "?" + queryString : "";
    }
}

