/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.common.util;

import com.github.pagehelper.Page;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;

public class Paging<T>
implements Serializable,
Iterable<T> {
    private long totalRow;
    private long pageSize = 10L;
    private long totalPage;
    private long currentPage = 1L;
    private Collection<T> data;

    public static <T> Paging<T> build(int currentPage, int pageSize, long total, List<T> data) {
        Paging<T> paging = new Paging<T>();
        paging.setCurrentPage(currentPage);
        paging.setPageSize(pageSize);
        paging.setTotalRow(total);
        paging.setData(data);
        return paging;
    }

    public static <T> Paging<T> build(int currentPage, int pageSize, List<T> data) {
        Paging<T> paging = new Paging<T>();
        paging.setCurrentPage(currentPage);
        paging.setPageSize(pageSize);
        if (data instanceof Page) {
            paging.setTotalRow(((Page)data).getTotal());
        }
        paging.setData(data);
        return paging;
    }

    public static <T> Paging<T> build(int currentPage, int pageSize, long totalRow) {
        Paging<T> paging = new Paging<T>();
        paging.setCurrentPage(currentPage);
        paging.setPageSize(pageSize);
        paging.setTotalRow(totalRow);
        return paging;
    }

    public Paging setTotalRow(long totalRow) {
        this.totalRow = totalRow;
        this.setTotalPage(this.totalRow / this.getPageSize() + (long)(this.totalRow % this.getPageSize() != 0L ? 1 : 0));
        return this;
    }

    public long getStart() {
        return (this.getCurrentPage() - 1L) * this.getPageSize();
    }

    public long getEnd() {
        return this.getStart() + this.getPageSize();
    }

    public Paging setData(Collection<T> data) {
        this.data = data;
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.data.forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.data.spliterator();
    }

    public long getTotalRow() {
        return this.totalRow;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public long getCurrentPage() {
        return this.currentPage;
    }

    public Collection<T> getData() {
        return this.data;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public void setCurrentPage(long currentPage) {
        this.currentPage = currentPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Paging)) {
            return false;
        }
        Paging other = (Paging)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalRow() != other.getTotalRow()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        if (this.getCurrentPage() != other.getCurrentPage()) {
            return false;
        }
        Collection<T> this$data = this.getData();
        Collection<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Paging;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalRow = this.getTotalRow();
        result = result * 59 + (int)($totalRow >>> 32 ^ $totalRow);
        long $pageSize = this.getPageSize();
        result = result * 59 + (int)($pageSize >>> 32 ^ $pageSize);
        long $totalPage = this.getTotalPage();
        result = result * 59 + (int)($totalPage >>> 32 ^ $totalPage);
        long $currentPage = this.getCurrentPage();
        result = result * 59 + (int)($currentPage >>> 32 ^ $currentPage);
        Collection<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "Paging(totalRow=" + this.getTotalRow() + ", pageSize=" + this.getPageSize() + ", totalPage=" + this.getTotalPage() + ", currentPage=" + this.getCurrentPage() + ", data=" + this.getData() + ")";
    }
}

