/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GeneratorHelp {
    public static final Map<String, String> db2JavaType = Maps.newHashMap();
    public static final Pattern COLUMN_PATTERN = Pattern.compile("`(.*?)`\\s(\\w+)(\\(.*?\\))?\\s.*?(COMMENT\\s'(.*?)')?,");
    public static final Pattern TABLE_PATTERN = Pattern.compile("(?i)CREATE\\sTABLE\\s`(.*?)`");
    public static final Pattern CAMEL_FIRST_CHAR_PATTERN = Pattern.compile("_(\\w)");
    public static final Pattern TABLE_COMMENT_PATTERN = Pattern.compile("COMMENT='(.*?)';");

    public static void main(String[] args) {
        String sql = "CREATE TABLE `b_company_contract` (\n  `COMPANY_ID` bigint(20) NOT NULL,\n  `ID` bigint(20) NOT NULL,\n  `PRODUCT` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '\u670d\u52a1\u4ea7\u54c1\\r\\nWB_RSDL:\u5916\u5305-\u4eba\u4e8b\u4ee3\u7406\\r\\nWB_LWPQ:\u5916\u5305-\u52b3\u52a1\u6d3e\u9063\\r\\nWB_GWPQ:\u5916\u5305-\u5c97\u4f4d\u5916\u5305\\r\\nWB_YWWB:\u5916\u5305-\u4e1a\u52a1\u5916\u5305\\r\\nLT:\u730e\u5934\\r\\nPRO:RPO\\r\\nQYPX:\u4f01\u4e1a\u5185\u8bad\\r\\nTZ:\u62d3\u5c55\\r\\nGLZX:\u7ba1\u7406\u54a8\u8be2\\r\\nQT:\u5176\u4ed6',\n  `PRICE` decimal(10,2) NOT NULL COMMENT '\u603b\u4ef7',\n  `BEGIN_TIME` datetime NOT NULL COMMENT '\u6267\u884c\u65e5\u671f \u5f00\u59cb\u65f6\u95f4',\n  `END_TIME` datetime NOT NULL COMMENT '\u6267\u884c\u65e5\u671f \u7ed3\u675f\u65f6\u95f4',\n  `DEMAND_PERSON` int(10) DEFAULT NULL COMMENT '\u9700\u6c42\u91cf',\n  `DEMAND_DURATION` int(10) DEFAULT NULL COMMENT '\u9700\u6c42\u91cf \u65f6\u95f4(\u6708)',\n  `UNIT_PRICE` decimal(10,2) DEFAULT NULL COMMENT '\u5355\u4ef7 \u5143/\u4eba/\u6708',\n  `FEE_BASE_SB` decimal(10,2) DEFAULT NULL COMMENT '\u793e\u4fdd\u7f34\u8d39\u57fa\u6570',\n  `FEE_BASE_GJJ` decimal(10,2) DEFAULT NULL COMMENT '\u516c\u79ef\u91d1\u7f34\u8d39\u57fa\u6570',\n  `HAS_CONTRACT` char(1) CHARACTER SET utf8mb4 NOT NULL DEFAULT 'Y' COMMENT '\u662f\u5426\u7b7e\u8ba2\u5408\u540c Y:\u662f N\uff1a\u5426',\n  `OTHER_NAME` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '\u5bf9\u65b9\u5ba2\u6237\u540d\u79f0',\n  `OTHER_CONTRACT_NAME` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '\u5bf9\u65b9\u5408\u540c\u4e3b\u4f53\u540d\u79f0',\n  `OTHER_CONTACT_NAME` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '\u5bf9\u65b9\u8d1f\u8d23\u4eba',\n  `OTHER_CONTACT_MOBILE` bigint(11) DEFAULT NULL COMMENT '\u5bf9\u65b9\u8d1f\u8d23\u4eba\u624b\u673a',\n  `OTHER_CONTACT_EMAIL` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '\u5bf9\u65b9\u8d1f\u8d23\u4eba\u90ae\u7bb1',\n  `OTHER_ADDRESS` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '\u5bf9\u65b9\u516c\u53f8\u5730\u5740',\n  `OUR_NAME` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '\u6211\u65b9\u5ba2\u6237\u540d\u79f0',\n  `OUR_CONTRACT_NAME` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '\u6211\u65b9\u5408\u540c\u4e3b\u4f53\u540d\u79f0',\n  `OUR_CONTACT_NAME` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '\u6211\u65b9\u8d1f\u8d23\u4eba',\n  `OUR_CONTACT_MOBILE` bigint(11) DEFAULT NULL COMMENT '\u6211\u65b9\u8d1f\u8d23\u4eba\u624b\u673a',\n  `OUR_CONTACT_EMAIL` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '\u6211\u65b9\u8d1f\u8d23\u4eba\u90ae\u7bb1',\n  `OUR_ADDRESS` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '\u6211\u65b9\u516c\u53f8\u5730\u5740',\n  `ATTACH_URL` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '\u9644\u4ef6\u5730\u5740',\n  `CREATE_TIME` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,\n  `CREATE_USER_ID` bigint(20) NOT NULL,\n  PRIMARY KEY (`ID`)\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='\u4f01\u4e1a\u5408\u540c';\n\n";
        GeneratorHelp.printInfo(sql);
    }

    private static void printInfo(String sql) {
        StringBuilder modelBuilder = new StringBuilder();
        StringBuilder insertBuilder = new StringBuilder();
        ArrayList insertColumns = Lists.newArrayList();
        ArrayList insertProperties = Lists.newArrayList();
        StringBuilder selectBuilder = new StringBuilder();
        ArrayList selectColumns = Lists.newArrayList();
        Matcher tableMatcher = TABLE_PATTERN.matcher(sql);
        tableMatcher.find();
        Matcher tableCommentMatcher = TABLE_COMMENT_PATTERN.matcher(sql);
        boolean hasComment = tableCommentMatcher.find();
        if (hasComment) {
            modelBuilder.append("@ApiModel(value = \"").append(tableCommentMatcher.group(1)).append("\")\n");
        }
        modelBuilder.append("@Data\npublic class ");
        modelBuilder.append(GeneratorHelp.getName(StringUtils.capitalize((String)tableMatcher.group(1).replaceFirst("\\w_", "")))).append(" {\n");
        insertBuilder.append("INSERT INTO ").append(tableMatcher.group(1).toUpperCase()).append("(");
        selectBuilder.append("SELECT ");
        Matcher columnMatcher = COLUMN_PATTERN.matcher(sql);
        while (columnMatcher.find()) {
            String comment = columnMatcher.group(5);
            String type = db2JavaType.get(columnMatcher.group(2).toLowerCase());
            String name = GeneratorHelp.getName(columnMatcher.group(1).toLowerCase());
            insertColumns.add(columnMatcher.group(1));
            insertProperties.add("#{" + name + "}");
            if (selectColumns.size() != 0) {
                selectColumns.add("\n      ,A." + columnMatcher.group(1));
            } else {
                selectColumns.add("\n       A." + columnMatcher.group(1));
            }
            if (columnMatcher.group(5) != null) {
                modelBuilder.append("    @ApiModelProperty(value = \"").append(comment).append("\")\n");
            }
            if ("LocalDate".equals(type)) {
                modelBuilder.append("    @JsonSerialize(using = DateSerializer.YYYY_MM_DD.class)\n");
                modelBuilder.append("    @JsonDeserialize(using = DateDeserializer.class)\n");
            } else if ("LocalDateTime".equals(type)) {
                modelBuilder.append("    @JsonSerialize(using = DateTimeSerializer.YYYY_MM_DD_HH_MM_SS.class)\n");
                modelBuilder.append("    @JsonDeserialize(using = DateTimeDeserializer.class)\n");
            }
            if ("createUserId".equals(name)) {
                modelBuilder.append("    private User createUser;\n");
                continue;
            }
            if ("updateUserId".equals(name)) {
                modelBuilder.append("    private User updateUser;\n");
                continue;
            }
            modelBuilder.append("    private ").append(type).append(" ").append(name).append(";\n");
        }
        modelBuilder.append("}");
        System.out.println("==================Model============================");
        System.out.println(modelBuilder.toString());
        System.out.println("==================insert============================");
        insertBuilder.append(String.join((CharSequence)", ", insertColumns));
        insertBuilder.append(")\nVALUES\n(");
        insertBuilder.append(String.join((CharSequence)", ", insertProperties));
        insertBuilder.append("\n)");
        System.out.println(insertBuilder.toString());
        System.out.println("==================select============================");
        selectBuilder.append(String.join((CharSequence)"", selectColumns));
        selectBuilder.append("\n FROM ").append(tableMatcher.group(1).toUpperCase()).append(" A");
        System.out.println(selectBuilder.toString());
    }

    private static String getName(String name) {
        Matcher m = CAMEL_FIRST_CHAR_PATTERN.matcher(name);
        while (m.find()) {
            name = m.replaceFirst(m.group(1).toUpperCase());
            m.reset(name);
        }
        return name;
    }

    static {
        db2JavaType.put("bigint", "long");
        db2JavaType.put("int", "int");
        db2JavaType.put("tinyint", "int");
        db2JavaType.put("char", "String");
        db2JavaType.put("varchar", "String");
        db2JavaType.put("text", "String");
        db2JavaType.put("date", "LocalDate");
        db2JavaType.put("datetime", "LocalDateTime");
        db2JavaType.put("decimal", "BigDecimal");
    }
}

