/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.common.spring;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class CommonExceptionAdviceHandler {
    private static final Logger log = LoggerFactory.getLogger(CommonExceptionAdviceHandler.class);

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<?> exceptionHandler(HttpServletRequest request, Throwable ex) {
        log.error("\u7cfb\u7edf\u5f02\u5e38", ex);
        HashMap errorMsg = Maps.newHashMap();
        errorMsg.put("title", "\u7cfb\u7edf\u5f02\u5e38");
        errorMsg.put("exception", ClassUtils.getShortName(ex.getClass()));
        errorMsg.put("message", ex.getMessage());
        return new ResponseEntity((Object)errorMsg, this.getStatus(request));
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (statusCode == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return HttpStatus.valueOf((int)statusCode);
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BindException.class})
    public Map<String, Object> handleBindException(HttpServletRequest request, BindException bindException) throws IOException {
        return this.errorProcess(request, "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef", this.buildObjectBindException(bindException.getBindingResult()));
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Map<String, Object> handleBindException(HttpServletRequest request, MethodArgumentNotValidException bindException) throws IOException {
        return this.errorProcess(request, "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef", this.buildObjectBindException(bindException.getBindingResult()));
    }

    private Exception buildObjectBindException(BindingResult bindingResult) {
        return new InvalidParameterException(bindingResult.getFieldErrors().stream().map(fieldError -> fieldError.getObjectName() + "." + fieldError.getField() + ":" + fieldError.getDefaultMessage() + ";").reduce(String::concat).orElse(""));
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ConstraintViolationException.class})
    public Map<String, Object> handleBindException(HttpServletRequest request, ConstraintViolationException bindException) throws IOException {
        return this.errorProcess(request, "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef", new InvalidParameterException(bindException.getConstraintViolations().stream().map(constraintViolation -> "\u8f93\u5165\u7684\u503c:" + constraintViolation.getInvalidValue() + ",\u63d0\u793a:" + constraintViolation.getMessage() + ";").reduce(String::concat).orElse("")));
    }

    private Map<String, Object> errorProcess(HttpServletRequest request, String exceptionSubject, Throwable ex) throws IOException {
        log.error(exceptionSubject + ",{}", (Object)(request.getRequestURL() + "?" + request.getQueryString()), (Object)ex);
        HashMap errorMsg = Maps.newHashMap();
        errorMsg.put("title", exceptionSubject);
        errorMsg.put("exceptionType", ClassUtils.getShortName(ex.getClass()));
        errorMsg.put("message", ex.getMessage());
        return errorMsg;
    }
}

