/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.common.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TimeDeserializer
extends JsonDeserializer<LocalTime> {
    public static final String HH_MM_SS = "HH$1mm$2ss$3";
    public static final String HH_MM = "HH$1mm$2";
    public static final String HH = "HH$1";
    private static final Map<String, Pattern> patternMap = Maps.newLinkedHashMap();

    public static void main(String[] args) {
        System.out.println(TimeDeserializer.getPattern("11:11:11"));
        System.out.println(TimeDeserializer.getPattern("11\u70b911\u5206"));
        System.out.println(TimeDeserializer.getPattern("11\u70b9"));
        System.out.println(TimeDeserializer.getPattern("11"));
    }

    private static String getPattern(String dateString) {
        for (Map.Entry<String, Pattern> entry : patternMap.entrySet()) {
            Matcher matcher = entry.getValue().matcher(dateString);
            if (!matcher.find()) continue;
            if (HH_MM_SS.equals(entry.getKey())) {
                return HH_MM_SS.replace("$1", matcher.group(1)).replace("$2", matcher.group(2)).replace("$3", matcher.group(3));
            }
            if (HH_MM.equals(entry.getKey())) {
                return HH_MM.replace("$1", matcher.group(1)).replace("$2", matcher.group(2));
            }
            if (!HH.equals(entry.getKey())) continue;
            return HH.replace("$1", matcher.group(1));
        }
        return null;
    }

    public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)p.getText())) {
            return null;
        }
        String pattern = TimeDeserializer.getPattern(p.getText());
        if (pattern == null) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u683c\u5f0f:" + p.getText());
        }
        return LocalTime.parse(p.getText(), DateTimeFormatter.ofPattern(pattern));
    }

    static {
        patternMap.put(HH_MM_SS, Pattern.compile("^\\d{1,2}([^\\d]+)\\d{1,2}([^\\d]+)\\d{1,2}([^\\d]?)$"));
        patternMap.put(HH_MM, Pattern.compile("^\\d{1,2}([^\\d]+)\\d{1,2}([^\\d]?)$"));
        patternMap.put(HH, Pattern.compile("^\\d{1,2}([^\\d]?)$"));
    }
}

