/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.common.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ObjectMapperCustomized
extends ObjectMapper {
    public ObjectMapperCustomized() {
        DefaultSerializerProvider.Impl sp = new DefaultSerializerProvider.Impl();
        this.setSerializerProvider((DefaultSerializerProvider)sp);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(String.class, (JsonDeserializer)new StdDeserializer<String>(String.class){

            public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String result = StringDeserializer.instance.deserialize(p, ctxt);
                if (StringUtils.isBlank((CharSequence)result)) {
                    return null;
                }
                return result;
            }
        });
        this.registerModule((Module)module);
    }
}

