/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.common.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class CommonModule
extends SimpleModule {
    private static JsonSerializer<Long> longSerializer = new StdSerializer<Long>(Long.class){

        public void serialize(Long value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
                return;
            }
            gen.writeString(String.valueOf(value));
        }
    };

    public CommonModule() {
        this.addSerializer(Long.TYPE, longSerializer).addSerializer(Long.class, longSerializer).addDeserializer(String.class, (JsonDeserializer)new StdDeserializer<String>(String.class){

            public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String result = StringDeserializer.instance.deserialize(p, ctxt);
                if (StringUtils.isBlank((CharSequence)result)) {
                    return null;
                }
                return StringUtils.trim((String)result);
            }
        });
    }
}

