/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.common.excel;

import cn.ocoop.framework.common.excel.CellData;
import cn.ocoop.framework.common.excel.CellValueMapper;
import cn.ocoop.framework.common.excel.DataWrapper;
import cn.ocoop.framework.common.excel.InvalidValueException;
import cn.ocoop.framework.common.excel.RowData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ExcelParser<T> {
    private static final Logger log = LoggerFactory.getLogger(ExcelParser.class);
    private Set<Integer> proceedRowsIndex = Collections.synchronizedSet(new TreeSet(Comparator.reverseOrder()));
    private List<DataWrapper<T>> data = Lists.newArrayList();
    private int rowNumStart;
    private int cellNumStart;
    private Class<T> modelClass;
    private LinkedHashMap<String, CellValueMapper> cellMapper;
    private Map<Integer, CellValueMapper> cellIndex_checker = Maps.newHashMap();
    private Workbook workbook;
    private boolean error;

    public ExcelParser(int rowNumStart, int cellNumStart, InputStream inputStream, Class<T> modelClass, LinkedHashMap<String, CellValueMapper> cellMapper) throws IOException, InvalidFormatException {
        this.rowNumStart = rowNumStart;
        this.cellNumStart = cellNumStart;
        this.modelClass = modelClass;
        this.cellMapper = cellMapper;
        int cellIndex = cellNumStart;
        for (CellValueMapper checker : this.cellMapper.values()) {
            this.cellIndex_checker.put(cellIndex++, checker);
        }
        this.workbook = WorkbookFactory.create((InputStream)inputStream);
    }

    public static <T> ExcelParser<T> newInstance(int rowNumStart, int cellNumStart, InputStream inputStream, Class<T> modelClass, LinkedHashMap<String, CellValueMapper> cellMapper) throws IOException, InvalidFormatException {
        return new ExcelParser<T>(rowNumStart, cellNumStart, inputStream, modelClass, cellMapper);
    }

    public void sax() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Sheet sheet = this.workbook.getSheetAt(0);
        for (int rowNum = this.rowNumStart; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) {
                this.proceedRowsIndex.add(rowNum);
                continue;
            }
            RowData rowData = new RowData();
            rowData.setIndex(rowNum);
            log.info("\u884c\u53f7\uff1a{}", (Object)row.getRowNum());
            for (int cellIndex = this.cellNumStart; cellIndex < this.cellNumStart + this.cellMapper.size(); ++cellIndex) {
                Cell cell = row.getCell(cellIndex, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                CellData cellData2 = new CellData(cellIndex, cell != null ? this.getValue(cell) : null);
                CellValueMapper cellValueMapper = this.cellIndex_checker.get(cellIndex);
                Assert.notNull((Object)cellValueMapper, (String)"\u672a\u627e\u5230\u5408\u9002\u7684\u5904\u7406mapper");
                try {
                    cellData2.setTypedValue(cellValueMapper.map((String)cellData2.getValue()));
                }
                catch (InvalidValueException e) {
                    log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25", (Throwable)e);
                    cellData2.setMessage(e.getMessage());
                }
                rowData.addCell(cellData2);
            }
            if (rowData.getCellData().stream().allMatch(cellData -> cellData.getValue() == null)) {
                this.proceedRowsIndex.add(rowData.getIndex());
                continue;
            }
            if (rowData.getCellData().stream().noneMatch(CellData::hasError)) {
                Object model = ConstructorUtils.invokeConstructor(this.modelClass, null);
                int index = 0;
                for (String property : this.cellMapper.keySet()) {
                    BeanUtils.setProperty((Object)model, (String)property, (Object)rowData.getCellData().get(index++).getTypedValue());
                }
                this.data.add(new DataWrapper<Object>(rowData.getIndex(), model));
                continue;
            }
            this.error(rowData.getIndex(), rowData.getCellData().stream().filter(cellData -> StringUtils.isNotBlank((CharSequence)cellData.getMessage())).map(CellData::getMessage).collect(Collectors.joining(";")));
        }
    }

    public void error(int rowIndex, String message) {
        this.error = true;
        Sheet sheet = this.workbook.getSheetAt(0);
        Row row = sheet.getRow(rowIndex);
        Cell cell = row.createCell(this.cellNumStart + this.cellMapper.size());
        Font font = this.workbook.createFont();
        font.setColor(IndexedColors.RED.index);
        CellStyle style = this.workbook.createCellStyle();
        style.setFont(font);
        cell.setCellStyle(style);
        cell.setCellValue(message);
    }

    private String getValue(Cell cell) {
        switch (cell.getCellTypeEnum()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    if (cell.getDateCellValue() == null) {
                        return null;
                    }
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cell.getDateCellValue());
                }
                String numString = new DecimalFormat("#.00").format(cell.getNumericCellValue());
                while (numString.endsWith("0")) {
                    numString = StringUtils.removeEnd((String)numString, (String)"0");
                }
                return StringUtils.removeEnd((String)numString, (String)".");
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
            case BLANK: {
                return null;
            }
        }
        return null;
    }

    public void proceed(int rowIndex) {
        this.proceedRowsIndex.add(rowIndex);
    }

    public void write(OutputStream outputStream) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(0);
        for (Integer rowIndex : this.proceedRowsIndex) {
            sheet.shiftRows(Math.min(sheet.getLastRowNum(), rowIndex + 1), sheet.getLastRowNum(), -1);
        }
        this.workbook.write(outputStream);
    }

    public List<DataWrapper<T>> getData() {
        return this.data;
    }

    public boolean isError() {
        return this.error;
    }
}

