/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.sql;

import cn.ocoop.framework.sql.AbstractMysqlTenantASTVisitorAdapter;
import cn.ocoop.framework.sql.MySqlSelectTenantOptimizer;
import cn.ocoop.framework.sql.TC;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlCharExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MySqlInsertTenantOptimizer
extends AbstractMysqlTenantASTVisitorAdapter {
    private int insertColumnNum = 0;

    public MySqlInsertTenantOptimizer(String tenantColumn, String tenantColumnType) {
        super(tenantColumn, tenantColumnType);
    }

    public boolean visit(MySqlInsertStatement x) {
        super.visit(x);
        SQLIdentifierExpr merchantIdColumn = new SQLIdentifierExpr(this.tenantColumn);
        if (!x.getColumns().contains(merchantIdColumn)) {
            x.addColumn((SQLExpr)merchantIdColumn);
            for (SQLInsertStatement.ValuesClause valuesClause : x.getValuesList()) {
                Object merchantIdValue = "String".equals(this.tenantColumnType) ? new MySqlCharExpr((String)TC.get()) : new SQLIntegerExpr((Number)TC.get());
                if (valuesClause.getValues().contains(merchantIdValue)) continue;
                valuesClause.addValue((SQLExpr)merchantIdValue);
            }
        }
        this.insertColumnNum = x.getColumns().size();
        return true;
    }

    public boolean visit(MySqlSelectQueryBlock x) {
        Object leftExpr;
        SQLSelectItem sqlSelectItem;
        super.visit(x);
        SQLExprTableSource sqlTableSource = this.recursiveGetOwner(x.getFrom());
        List selectList = x.getSelectList();
        if (selectList.size() == this.insertColumnNum - 1 && !selectList.contains(sqlSelectItem = new SQLSelectItem((SQLExpr)(leftExpr = StringUtils.isNotBlank((CharSequence)sqlTableSource.getAlias()) ? new SQLPropertyExpr(sqlTableSource.getAlias(), this.tenantColumn) : new SQLIdentifierExpr(this.tenantColumn))))) {
            x.addSelectItem(sqlSelectItem);
        }
        return new MySqlSelectTenantOptimizer(this.tenantColumn, this.tenantColumnType).visit(x);
    }

    public SQLExprTableSource recursiveGetOwner(SQLTableSource sqlTableSource) {
        if (sqlTableSource instanceof SQLExprTableSource) {
            return (SQLExprTableSource)sqlTableSource;
        }
        if (sqlTableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource tableSource = (SQLJoinTableSource)sqlTableSource;
            return this.recursiveGetOwner(tableSource.getLeft());
        }
        return null;
    }
}

