/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.session;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;

public class RedisSessionDAO
extends AbstractSessionDAO {
    private RedisTemplate redisTemplate;
    private String sessionCacheName = "shiro:session:";

    public RedisSessionDAO() {
    }

    public RedisSessionDAO(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String getSessionCacheName() {
        return this.sessionCacheName;
    }

    public void setSessionCacheName(String sessionCacheName) {
        this.sessionCacheName = sessionCacheName;
    }

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.saveSession(session);
        return sessionId;
    }

    private void saveSession(final Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        final Long expireValue = session.getTimeout() / 1000L;
        final String sessionKey = this.getSessionKey(session.getId());
        this.redisTemplate.execute((SessionCallback)new SessionCallback<List<Object>>(){

            public List<Object> execute(RedisOperations operations) throws DataAccessException {
                operations.multi();
                operations.opsForValue().set((Object)sessionKey, (Object)session);
                operations.expire((Object)sessionKey, expireValue.longValue(), TimeUnit.SECONDS);
                return operations.exec();
            }
        });
    }

    private String getSessionKey(Serializable sessionId) {
        return this.sessionCacheName + sessionId;
    }

    protected Session doReadSession(Serializable sessionId) {
        if (sessionId == null) {
            return null;
        }
        return (Session)this.redisTemplate.opsForValue().get((Object)this.getSessionKey(sessionId));
    }

    public void update(Session session) throws UnknownSessionException {
        this.saveSession(session);
    }

    public void delete(Session session) {
        if (session.getId() == null) {
            return;
        }
        this.redisTemplate.delete((Object)this.getSessionKey(session.getId()));
    }

    public Collection<Session> getActiveSessions() {
        Set keys = this.redisTemplate.keys((Object)(this.sessionCacheName + "*"));
        if (CollectionUtils.isEmpty((Collection)keys)) {
            return null;
        }
        return this.redisTemplate.opsForValue().multiGet((Collection)keys);
    }
}

