/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.filter;

import cn.ocoop.framework.config.RequestProperties;
import cn.ocoop.framework.util.RequestUtils;
import cn.ocoop.framework.util.ResponseUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormAuthenticationFilter
extends org.apache.shiro.web.filter.authc.FormAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(FormAuthenticationFilter.class);
    private RequestProperties requestProperties;

    public RequestProperties getRequestProperties() {
        return this.requestProperties;
    }

    public void setRequestProperties(RequestProperties requestProperties) {
        this.requestProperties = requestProperties;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            if (this.isLoginSubmission(request, response)) {
                if (log.isTraceEnabled()) {
                    log.trace("Login submission detected.  Attempting to execute login.");
                }
                return this.executeLogin(request, response);
            }
            if (log.isTraceEnabled()) {
                log.trace("Login page view.");
            }
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace("Attempting to access a path which requires authentication.  Forwarding to the Authentication url [" + this.getLoginUrl() + "]");
        }
        if (RequestUtils.shouldUseNormalHttpRequestToProcess(request, this.requestProperties.isServiceOriented())) {
            this.saveRequestAndRedirectToLogin(request, response);
        } else {
            ResponseUtils.responseInvalidLogin(response, this.requestProperties.getInvalidLoginCode());
        }
        return false;
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        if (RequestUtils.shouldUseNormalHttpRequestToProcess(request, this.requestProperties.isServiceOriented())) {
            this.issueSuccessRedirect(request, response);
        } else {
            ResponseUtils.responseJson(response, 200, Maps.immutableEntry((Object)this.requestProperties.getLogInOutResponseKey(), (Object)true));
        }
        return false;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        if (log.isDebugEnabled()) {
            log.debug("Authentication exception", (Throwable)e);
        }
        if (RequestUtils.shouldUseNormalHttpRequestToProcess(request, this.requestProperties.isServiceOriented())) {
            this.setFailureAttribute(request, e);
            return true;
        }
        try {
            ResponseUtils.responseJson(response, 200, Maps.immutableEntry((Object)this.requestProperties.getLogInOutResponseKey(), (Object)false));
        }
        catch (IOException e1) {
            log.error("response login fail fails", (Throwable)e1);
        }
        return false;
    }
}

