/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.filter;

import cn.ocoop.framework.config.RequestProperties;
import cn.ocoop.framework.filter.AnyRolesAuthorizationFilter;
import cn.ocoop.framework.filter.BasicHttpAuthenticationFilter;
import cn.ocoop.framework.filter.FormAuthenticationFilter;
import cn.ocoop.framework.filter.HttpMethodPermissionFilter;
import cn.ocoop.framework.filter.LogoutFilter;
import cn.ocoop.framework.filter.PermissionsAuthorizationFilter;
import cn.ocoop.framework.filter.RolesAuthorizationFilter;
import cn.ocoop.framework.filter.UserFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.shiro.util.ClassUtils;
import org.apache.shiro.web.filter.authc.AnonymousFilter;
import org.apache.shiro.web.filter.session.NoSessionCreationFilter;

public enum DefaultFilter {
    anon(AnonymousFilter.class),
    authc(FormAuthenticationFilter.class),
    authcBasic(BasicHttpAuthenticationFilter.class),
    logout(LogoutFilter.class),
    noSessionCreation(NoSessionCreationFilter.class),
    perms(PermissionsAuthorizationFilter.class),
    rest(HttpMethodPermissionFilter.class),
    roles(RolesAuthorizationFilter.class),
    anyRoles(AnyRolesAuthorizationFilter.class),
    user(UserFilter.class);

    private final Class<? extends Filter> filterClass;

    private DefaultFilter(Class<? extends Filter> filterClass) {
        this.filterClass = filterClass;
    }

    public static Map<String, Filter> createInstanceMap(RequestProperties requestProperties) throws InvocationTargetException, IllegalAccessException {
        LinkedHashMap<String, Filter> filters = new LinkedHashMap<String, Filter>(DefaultFilter.values().length);
        for (DefaultFilter defaultFilter : DefaultFilter.values()) {
            Filter filter = defaultFilter.newInstance();
            BeanUtils.setProperty((Object)filter, (String)"requestProperties", (Object)requestProperties);
            filters.put(defaultFilter.name(), filter);
        }
        return filters;
    }

    public Filter newInstance() {
        return (Filter)ClassUtils.newInstance(this.filterClass);
    }
}

