/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.filter;

import cn.ocoop.framework.config.RequestProperties;
import cn.ocoop.framework.util.RequestUtils;
import cn.ocoop.framework.util.ResponseUtils;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;

public abstract class AuthorizationWithStatusCodeFilter
extends AuthorizationFilter {
    private RequestProperties requestProperties;

    public RequestProperties getRequestProperties() {
        return this.requestProperties;
    }

    public void setRequestProperties(RequestProperties requestProperties) {
        this.requestProperties = requestProperties;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        if (RequestUtils.shouldUseNormalHttpRequestToProcess(request, this.requestProperties.isServiceOriented())) {
            return super.onAccessDenied(request, response);
        }
        Subject subject = this.getSubject(request, response);
        if (subject.getPrincipal() == null) {
            ResponseUtils.responseInvalidLogin(response, this.requestProperties.getInvalidLoginCode());
        } else {
            ResponseUtils.responseInvalidPermission(response, this.requestProperties.getInvalidPermissionCode());
        }
        return false;
    }
}

