/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.config;

import cn.ocoop.framework.config.RequestProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.Realm;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="shiro")
public class ShiroProperties {
    public static final String PREFIX = "shiro";
    private List<RealmDefinition> realms = new ArrayList<RealmDefinition>();
    private RequestProperties requestProperties = new RequestProperties();

    public RequestProperties getRequestProperties() {
        return this.requestProperties;
    }

    public void setRequestProperties(RequestProperties requestProperties) {
        this.requestProperties = requestProperties;
    }

    public List<Realm> realms() {
        return this.realms.stream().map(realmDefinition -> realmDefinition.getRealm().getTarget()).collect(Collectors.toList());
    }

    public ShiroProperties afterPropertiesSet() {
        for (RealmDefinition realmDefinition : this.getRealms()) {
            this.setRealmProperty(realmDefinition);
            this.setCredentialsMatcherProperty(realmDefinition);
            this.setReamCredentialsMatcher(realmDefinition);
        }
        return this;
    }

    private void setReamCredentialsMatcher(RealmDefinition realmDefinition) {
        if (realmDefinition.getRealm().getTarget() instanceof AuthenticatingRealm) {
            ((AuthenticatingRealm)realmDefinition.getRealm().getTarget()).setCredentialsMatcher(realmDefinition.getRealm().getCredentialsMatcher().getTarget());
        }
    }

    private void setCredentialsMatcherProperty(RealmDefinition realmDefinition) {
        RealmProperty.CredentialsMatcherDefinition credentialsMatcherDefinition = realmDefinition.getRealm().getCredentialsMatcher();
        CredentialsMatcher matcher = credentialsMatcherDefinition.getTarget();
        credentialsMatcherDefinition.getProperty().forEach((propertyName, propertyValue) -> {
            try {
                BeanUtils.setProperty((Object)matcher, (String)propertyName, (Object)propertyValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
    }

    private void setRealmProperty(RealmDefinition realmDefinition) {
        realmDefinition.getRealm().getProperty().forEach((propertyName, propertyValue) -> {
            try {
                BeanUtils.setProperty((Object)realmDefinition, (String)propertyName, (Object)propertyValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
    }

    public List<RealmDefinition> getRealms() {
        return this.realms;
    }

    public void setRealms(List<RealmDefinition> realms) {
        this.realms = realms;
    }

    public static class RealmDefinition {
        private RealmProperty realm;

        public RealmProperty getRealm() {
            return this.realm;
        }

        public void setRealm(RealmProperty realm) {
            this.realm = realm;
        }
    }

    public static class RealmProperty {
        private Realm target;
        private Map<String, Object> property;
        private CredentialsMatcherDefinition credentialsMatcher;

        public Realm getTarget() {
            return this.target;
        }

        public void setTarget(Realm target) {
            this.target = target;
        }

        public Map<String, Object> getProperty() {
            return this.property;
        }

        public void setProperty(Map<String, Object> property) {
            this.property = property;
        }

        public CredentialsMatcherDefinition getCredentialsMatcher() {
            return this.credentialsMatcher;
        }

        public void setCredentialsMatcher(CredentialsMatcherDefinition credentialsMatcher) {
            this.credentialsMatcher = credentialsMatcher;
        }

        public static class CredentialsMatcherDefinition {
            private CredentialsMatcher target;
            private Map<String, Object> property;

            public CredentialsMatcher getTarget() {
                return this.target;
            }

            public void setTarget(CredentialsMatcher target) {
                this.target = target;
            }

            public Map<String, Object> getProperty() {
                return this.property;
            }

            public void setProperty(Map<String, Object> property) {
                this.property = property;
            }
        }
    }
}

