/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.cache;

import cn.ocoop.framework.cache.RedisCache;
import org.apache.shiro.cache.AbstractCacheManager;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCacheManager
extends AbstractCacheManager {
    private final RedisTemplate redisTemplate;

    public RedisCacheManager(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    protected Cache createCache(String name) throws CacheException {
        return new RedisCache(name, this.redisTemplate);
    }

    public void destroy() throws Exception {
        super.destroy();
        try {
            ((JedisConnectionFactory)this.redisTemplate.getConnectionFactory()).destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

