/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.cache;

import java.util.Collection;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCache<K, V>
implements Cache<K, V> {
    private final String name;
    private final RedisTemplate redisTemplate;

    public RedisCache(String name, RedisTemplate redisTemplate) {
        this.name = name;
        this.redisTemplate = redisTemplate;
    }

    public V get(K key) throws CacheException {
        return (V)this.redisTemplate.opsForValue().get((Object)this.getKey(key));
    }

    private String getKey(K key) {
        return this.name + ":" + key;
    }

    public V put(K key, V value) throws CacheException {
        V ret = this.get(key);
        this.redisTemplate.opsForValue().set((Object)this.getKey(key), value);
        return ret;
    }

    public V remove(K key) throws CacheException {
        V ret = this.get(key);
        this.redisTemplate.delete(key);
        return ret;
    }

    public void clear() throws CacheException {
        this.redisTemplate.delete((Collection)this.keys());
    }

    public int size() {
        return this.keys().size();
    }

    public Set keys() {
        return this.redisTemplate.keys((Object)(this.name + ":*"));
    }

    public Collection values() {
        return this.redisTemplate.opsForValue().multiGet((Collection)this.keys());
    }
}

