/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.authz;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Authorizer;
import org.apache.shiro.authz.ModularRealmAuthorizer;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.util.ClassUtils;

public class ModularSourceRealmAuthorizer
extends ModularRealmAuthorizer {
    public boolean hasRole(PrincipalCollection principals, String roleIdentifier) {
        this.assertRealmsConfigured();
        for (Realm realm : this.getRealms()) {
            if (!(realm instanceof Authorizer) || principals.fromRealm(realm.getName()).isEmpty() || !((Authorizer)realm).hasRole(principals, roleIdentifier)) continue;
            return true;
        }
        return false;
    }

    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        this.assertRealmsConfigured();
        for (Realm realm : this.getRealms()) {
            if (!(realm instanceof Authorizer) || principals.fromRealm(realm.getName()).isEmpty() || !((Authorizer)realm).isPermitted(principals, permission)) continue;
            return true;
        }
        return false;
    }

    public boolean isPermitted(PrincipalCollection principals, String permission) {
        this.assertRealmsConfigured();
        for (Realm realm : this.getRealms()) {
            if (!(realm instanceof Authorizer) || principals.fromRealm(realm.getName()).isEmpty() || !((Authorizer)realm).isPermitted(principals, permission)) continue;
            return true;
        }
        return false;
    }

    public List<String> getRoles() throws InvocationTargetException, IllegalAccessException {
        this.assertRealmsConfigured();
        PrincipalCollection principals = SecurityUtils.getSubject().getPrincipals();
        ArrayList<String> roles = new ArrayList<String>();
        for (Realm realm : this.getRealms()) {
            if (!(realm instanceof Authorizer) || principals.fromRealm(realm.getName()).isEmpty()) continue;
            Method getAuthorizationInfoMethod = ClassUtils.getMethod(realm.getClass(), (String)"getAuthorizationInfo", (Class[])new Class[]{PrincipalCollection.class});
            getAuthorizationInfoMethod.setAccessible(true);
            roles.addAll(((AuthorizationInfo)getAuthorizationInfoMethod.invoke((Object)realm, principals)).getRoles());
        }
        return roles;
    }

    public List<String> getPermissions() throws InvocationTargetException, IllegalAccessException {
        this.assertRealmsConfigured();
        PrincipalCollection principals = SecurityUtils.getSubject().getPrincipals();
        ArrayList<String> permissions = new ArrayList<String>();
        for (Realm realm : this.getRealms()) {
            if (!(realm instanceof Authorizer) || principals.fromRealm(realm.getName()).isEmpty()) continue;
            Method getAuthorizationInfoMethod = ClassUtils.getMethod(realm.getClass(), (String)"getAuthorizationInfo", (Class[])new Class[]{PrincipalCollection.class});
            getAuthorizationInfoMethod.setAccessible(true);
            permissions.addAll(((AuthorizationInfo)getAuthorizationInfoMethod.invoke((Object)realm, principals)).getStringPermissions());
        }
        return permissions;
    }
}

