/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe.filter;

import cn.ocoop.framework.safe.SessionManager;
import cn.ocoop.framework.safe.WebContext;
import cn.ocoop.framework.safe.utils.CookieUtils;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class SafeFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(SafeFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        WebContext.clear();
        WebContext.set(new WebContext.Context(request, response));
        Optional<Cookie> cookie = CookieUtils.get(request, SessionManager.safeProperties.getSessionIdCookieName());
        if (!cookie.isPresent()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String sessionId = cookie.get().getValue();
        if (SessionManager.touch(sessionId)) {
            WebContext.get().setSessionId(sessionId);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

