/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe.ann.handler.advice;

import cn.ocoop.framework.safe.SessionManager;
import cn.ocoop.framework.safe.ann.handler.AuthenticatedAnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ann.handler.CaptchaAnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ann.handler.GuestAnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ann.handler.PermissionAnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ann.handler.RoleAnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ann.handler.UserAnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ann.handler.iface.AnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ex.authz.AuthorizingException;
import com.google.common.collect.Lists;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections4.CollectionUtils;

public class AopAllianceAnnotationsAuthorizingMethodInterceptor
implements MethodInterceptor {
    private List<AnnotationMethodInterceptor> interceptors = Lists.newArrayList();

    public AopAllianceAnnotationsAuthorizingMethodInterceptor() {
        this.interceptors.add(new CaptchaAnnotationMethodInterceptor());
        this.interceptors.add(new RoleAnnotationMethodInterceptor());
        this.interceptors.add(new PermissionAnnotationMethodInterceptor());
        this.interceptors.add(new AuthenticatedAnnotationMethodInterceptor());
        this.interceptors.add(new UserAnnotationMethodInterceptor());
        this.interceptors.add(new GuestAnnotationMethodInterceptor());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        SessionManager.refreshCachedRoleAndPermissionIfNecessary();
        this.assertAuthorized(invocation);
        return invocation.proceed();
    }

    protected void assertAuthorized(MethodInvocation methodInvocation) throws AuthorizingException {
        if (CollectionUtils.isNotEmpty(this.interceptors)) {
            for (AnnotationMethodInterceptor mi : this.interceptors) {
                if (!mi.supports(methodInvocation)) continue;
                mi.assertAuthorized(methodInvocation);
            }
        }
    }
}

