/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebContext {
    private static final ThreadLocal<Context> THREAD_LOCAL = new InheritableThreadLocal<Context>();

    public static void clear() {
        THREAD_LOCAL.remove();
    }

    public static Context get() {
        return THREAD_LOCAL.get();
    }

    public static void set(Context context) {
        THREAD_LOCAL.set(context);
    }

    public static class Context {
        private HttpServletRequest request;
        private HttpServletResponse response;
        private String sessionId;

        public Context(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setRequest(HttpServletRequest request) {
            this.request = request;
        }

        public void setResponse(HttpServletResponse response) {
            this.response = response;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }
    }
}

