/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe;

import cn.ocoop.framework.safe.CaptchaProperty;
import cn.ocoop.framework.safe.SafeProperties;
import cn.ocoop.framework.safe.SessionManager;
import cn.ocoop.framework.safe.ann.handler.advice.AuthorizationAttributeSourceAdvisor;
import cn.ocoop.framework.safe.auth.controller.CaptchaController;
import cn.ocoop.framework.safe.auth.service.AuthorizingService;
import cn.ocoop.framework.safe.filter.SafeFilter;
import cn.ocoop.framework.safe.response.FieldFilterAdvice;
import javax.servlet.Filter;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@ConditionalOnBean(value={AuthorizingService.class})
@EnableConfigurationProperties(value={SafeProperties.class, CaptchaProperty.class})
public class SessionAutoConfiguration {
    public SessionAutoConfiguration(SafeProperties safeProperties, StringRedisTemplate redisTemplate, AuthorizingService authorizingService) {
        SessionManager.redisTemplate = redisTemplate;
        SessionManager.safeProperties = safeProperties;
        SessionManager.authorizingService = authorizingService;
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthorizationAttributeSourceAdvisor.class})
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor() {
        return new AuthorizationAttributeSourceAdvisor();
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultAdvisorAutoProxyCreator.class})
    @ConditionalOnMissingClass(value={"springfox.documentation.swagger2.annotations.EnableSwagger2"})
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        defaultAdvisorAutoProxyCreator.setProxyTargetClass(true);
        return defaultAdvisorAutoProxyCreator;
    }

    @Bean
    @ConditionalOnMissingBean(value={FieldFilterAdvice.class})
    public FieldFilterAdvice commonResponseBodyAdvice() {
        return new FieldFilterAdvice();
    }

    @Bean
    @ConditionalOnMissingBean(value={CaptchaController.class}, search=SearchStrategy.CURRENT)
    public CaptchaController captchaController() {
        return new CaptchaController();
    }

    @Bean
    @Order
    public FilterRegistrationBean safeFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new SafeFilter(), new ServletRegistrationBean[0]);
        filter.addUrlPatterns(new String[]{"/*"});
        return filter;
    }
}

