/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe;

import com.google.common.collect.Maps;
import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.ChineseCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import java.awt.FontFormatException;
import java.io.IOException;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
@ConfigurationProperties(prefix="safe.captcha")
public class CaptchaProperty {
    static final String PREFIX = "safe.captcha";
    private static Map<Class<? extends Captcha>, CaptchaSupplier> class_Strategy = Maps.newHashMap();
    private Class<? extends Captcha> type = ArithmeticCaptcha.class;
    private int width = 130;
    private int height = 48;
    private int length = 4;
    private int mixMode = 2;
    private int font = 0;

    public Captcha getCaptcha() throws IOException, FontFormatException {
        return class_Strategy.get(this.getType()).supplier(this);
    }

    public Class<? extends Captcha> getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLength() {
        return this.length;
    }

    public int getMixMode() {
        return this.mixMode;
    }

    public int getFont() {
        return this.font;
    }

    public void setType(Class<? extends Captcha> type) {
        this.type = type;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setMixMode(int mixMode) {
        this.mixMode = mixMode;
    }

    public void setFont(int font) {
        this.font = font;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaptchaProperty)) {
            return false;
        }
        CaptchaProperty other = (CaptchaProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<? extends Captcha> this$type = this.getType();
        Class<? extends Captcha> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getMixMode() != other.getMixMode()) {
            return false;
        }
        return this.getFont() == other.getFont();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CaptchaProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<? extends Captcha> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getLength();
        result = result * 59 + this.getMixMode();
        result = result * 59 + this.getFont();
        return result;
    }

    public String toString() {
        return "CaptchaProperty(type=" + this.getType() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", length=" + this.getLength() + ", mixMode=" + this.getMixMode() + ", font=" + this.getFont() + ")";
    }

    static {
        class_Strategy.put(SpecCaptcha.class, property -> {
            SpecCaptcha specCaptcha = new SpecCaptcha(property.getWidth(), property.getHeight(), property.getLength());
            specCaptcha.setFont(property.getFont());
            return specCaptcha;
        });
        class_Strategy.put(GifCaptcha.class, property -> {
            GifCaptcha gifCaptcha = new GifCaptcha(property.getWidth(), property.getHeight(), property.getLength());
            gifCaptcha.setFont(property.getFont());
            return gifCaptcha;
        });
        class_Strategy.put(ChineseCaptcha.class, property -> {
            ChineseCaptcha chineseCaptcha = new ChineseCaptcha(property.getWidth(), property.getHeight(), property.getLength());
            chineseCaptcha.setFont(property.getFont());
            return chineseCaptcha;
        });
        class_Strategy.put(ArithmeticCaptcha.class, property -> {
            ArithmeticCaptcha arithmeticCaptcha = new ArithmeticCaptcha(property.getWidth(), property.getHeight(), property.getLength());
            arithmeticCaptcha.setFont(property.getFont());
            return arithmeticCaptcha;
        });
    }

    @FunctionalInterface
    static interface CaptchaSupplier {
        public Captcha supplier(CaptchaProperty var1) throws IOException, FontFormatException;
    }
}

