/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe.response;

import cn.ocoop.framework.safe.SessionManager;
import cn.ocoop.framework.safe.response.FieldFilter;
import com.google.common.collect.Sets;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class FieldFilterAdvice
implements ResponseBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(FieldFilterAdvice.class);

    public static void setDefaultValue(Object o, String[] fieldName) throws InvocationTargetException, IllegalAccessException {
        if (fieldName.length == 1) {
            if (o instanceof Collection) {
                for (Object o1 : (Collection)o) {
                    FieldFilterAdvice.setDefaultValue(o1, fieldName);
                }
            } else if (o instanceof Map) {
                for (Object o1 : ((Map)o).values()) {
                    FieldFilterAdvice.setDefaultValue(o1, fieldName);
                }
            } else {
                ConvertUtils.register((Converter)new BigDecimalConverter(null), BigDecimal.class);
                ConvertUtils.register((Converter)new BigIntegerConverter(null), BigInteger.class);
                org.apache.commons.beanutils.BeanUtils.setProperty((Object)o, (String)fieldName[0], null);
            }
            return;
        }
        if (o instanceof Collection) {
            for (Object n : (Collection)o) {
                FieldFilterAdvice.setPDDefaultValue(fieldName, n, fieldName[0]);
            }
        } else if (o instanceof Map) {
            FieldFilterAdvice.setDefaultValue(((Map)o).values(), fieldName);
        } else {
            String currFileName = fieldName[0];
            FieldFilterAdvice.setPDDefaultValue(fieldName, o, currFileName);
        }
    }

    private static void setPDDefaultValue(String[] fieldName, Object n, String currFileName) {
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(n.getClass(), (String)currFileName);
        if (Objects.isNull(pd)) {
            return;
        }
        try {
            Object fieldValue = pd.getReadMethod().invoke(n, new Object[0]);
            FieldFilterAdvice.setDefaultValue(fieldValue, (String[])ArrayUtils.remove((Object[])fieldName, (int)0));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("\u65e0\u6cd5\u83b7\u53d6\u5c5e\u6027{}\u7684\u503c", (Object)fieldName, (Object)e);
        }
    }

    public boolean supports(MethodParameter methodParameter, Class aClass) {
        return true;
    }

    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (Objects.isNull(o)) {
            return null;
        }
        for (FieldFilter filter : this.executionFilters(methodParameter)) {
            if (this.requireAuthorized(filter)) {
                if (!this.lacksAuthentication(filter) && !this.lacksPermission(filter) && !this.lacksRole(filter)) continue;
                this.setDefaultPropertyValue(o, filter);
                continue;
            }
            this.setDefaultPropertyValue(o, filter);
        }
        return o;
    }

    private boolean requireAuthorized(FieldFilter filter) {
        return filter.requireAuthentication() || ArrayUtils.isNotEmpty((Object[])filter.requirePermission()) || ArrayUtils.isNotEmpty((Object[])filter.requireRole());
    }

    private Set<FieldFilter> executionFilters(MethodParameter methodParameter) {
        Object[] methodFilters;
        Method method;
        HashSet filters = Sets.newHashSet();
        Object[] classFilters = (FieldFilter[])methodParameter.getDeclaringClass().getAnnotationsByType(FieldFilter.class);
        if (ArrayUtils.isNotEmpty((Object[])classFilters)) {
            CollectionUtils.addAll((Collection)filters, (Object[])classFilters);
        }
        if ((method = methodParameter.getMethod()) != null && ArrayUtils.isNotEmpty((Object[])(methodFilters = (FieldFilter[])method.getAnnotationsByType(FieldFilter.class)))) {
            CollectionUtils.addAll((Collection)filters, (Object[])methodFilters);
        }
        return filters;
    }

    private void setDefaultPropertyValue(Object o, FieldFilter filter) {
        try {
            for (String field : filter.value()) {
                FieldFilterAdvice.setDefaultValue(o, field.split("\\."));
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("\u65e0\u6cd5\u6e05\u7a7a{}\u7684\u503c", (Object)filter.value(), (Object)e);
        }
    }

    private boolean lacksAuthentication(FieldFilter fieldFilter) {
        return fieldFilter.requireAuthentication() && !SessionManager.isLogin();
    }

    private boolean lacksPermission(FieldFilter fieldFilter) {
        return ArrayUtils.isNotEmpty((Object[])fieldFilter.requirePermission()) && !SessionManager.hasPermission(fieldFilter.requirePermission());
    }

    private boolean lacksRole(FieldFilter fieldFilter) {
        return ArrayUtils.isNotEmpty((Object[])fieldFilter.requireRole()) && !SessionManager.hasRole(fieldFilter.requireRole());
    }
}

