/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe.filter;

import cn.ocoop.framework.safe.SessionManager;
import cn.ocoop.framework.safe.WebContext;
import cn.ocoop.framework.safe.utils.CookieUtils;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class SafeFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(SafeFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        log.info("SafeFilter:\u8bf7\u6c42\u5730\u5740:{}{}", (Object)request.getRequestURL(), (Object)(StringUtils.isNotBlank((CharSequence)request.getQueryString()) ? "?" + request.getQueryString() : ""));
        WebContext.clear();
        WebContext.set(new WebContext.Context(request, response));
        Optional<Cookie> cookie = CookieUtils.get(request, SessionManager.safeProperties.getSession().getSessionIdCookieName());
        if (!cookie.isPresent()) {
            log.info("\u521b\u5efa\u65b0\u7684\u4f1a\u8bdd");
            String sessionId = this.createSession(response);
            WebContext.get().setSessionId(sessionId);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String sessionId = cookie.get().getValue();
        if (!SessionManager.touch(sessionId)) {
            log.info("\u4f1a\u8bdd:{}\u8d85\u65f6,\u91cd\u65b0\u521b\u5efa\u4f1a\u8bdd", (Object)sessionId);
            sessionId = this.createSession(response);
        }
        WebContext.get().setSessionId(sessionId);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String createSession(HttpServletResponse response) {
        String sessionId = SessionManager.createSessionId();
        SessionManager.createSession(response, sessionId);
        return sessionId;
    }
}

