/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe.ex;

import cn.ocoop.framework.safe.ex.authz.AuthorizingException;
import cn.ocoop.framework.safe.ex.authz.InvalidCaptchaException;
import cn.ocoop.framework.safe.ex.authz.LackPermissionException;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ExceptionAdviceHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAdviceHandler.class);

    @ExceptionHandler(value={AuthorizingException.class})
    public Map<String, String> authExceptionHandler(HttpServletRequest request, HttpServletResponse response, AuthorizingException ex) {
        int status = 401;
        if (ex instanceof LackPermissionException) {
            status = 444;
        } else if (ex instanceof InvalidCaptchaException) {
            status = 455;
        }
        response.setStatus(status);
        HashMap errorMsg = Maps.newHashMap();
        errorMsg.put("title", "\u4e0d\u6ee1\u8db3\u8bbf\u95ee\u6761\u4ef6");
        errorMsg.put("exception", ClassUtils.getShortName(ex.getClass()));
        errorMsg.put("message", ex.getMessage());
        return errorMsg;
    }
}

