/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe.ann.handler.iface;

import cn.ocoop.framework.safe.ann.handler.iface.AnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ex.InvalidConfigStateException;
import cn.ocoop.framework.safe.ex.authz.AuthorizingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

public abstract class AbstractAnnotationMethodInterceptor
implements AnnotationMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractAnnotationMethodInterceptor.class);
    protected Class<? extends Annotation> annotationClass;

    public AbstractAnnotationMethodInterceptor() {
    }

    public AbstractAnnotationMethodInterceptor(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    @Override
    public boolean supports(MethodInvocation mi) {
        if (this.annotationClass == null) {
            throw new InvalidConfigStateException("\u672a\u6b63\u786e\u914d\u7f6eAnnotationMethodIntercept");
        }
        return this.getAnnotation(mi, this.annotationClass) != null;
    }

    @Override
    public void assertAuthorized(MethodInvocation methodInvocation) throws AuthorizingException {
        Annotation annotation = this.getAnnotation(methodInvocation, this.annotationClass);
        try {
            this.assertAuth(methodInvocation, annotation);
        }
        catch (AuthorizingException e) {
            log.error("\u6ca1\u6709\u8bbf\u95ee\u6743\u9650:{}{}", (Object)methodInvocation.getMethod(), (Object)e.getMessage());
            throw e;
        }
    }

    protected abstract void assertAuth(MethodInvocation var1, Annotation var2) throws AuthorizingException;

    protected Annotation getAnnotation(MethodInvocation mi, Class<? extends Annotation> annotationClass) {
        Method m = mi.getMethod();
        Annotation a = AnnotationUtils.findAnnotation((Method)m, annotationClass);
        if (a != null) {
            return a;
        }
        Class<?> targetClass = mi.getThis().getClass();
        a = AnnotationUtils.findAnnotation((Method)(m = ClassUtils.getMostSpecificMethod((Method)m, targetClass)), annotationClass);
        if (a != null) {
            return a;
        }
        return AnnotationUtils.findAnnotation(mi.getThis().getClass(), annotationClass);
    }
}

