/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe.ann.handler.advice;

import cn.ocoop.framework.safe.ann.RequiresAuthentication;
import cn.ocoop.framework.safe.ann.RequiresCaptcha;
import cn.ocoop.framework.safe.ann.RequiresGuest;
import cn.ocoop.framework.safe.ann.RequiresPermissions;
import cn.ocoop.framework.safe.ann.RequiresRoles;
import cn.ocoop.framework.safe.ann.RequiresUser;
import cn.ocoop.framework.safe.ann.handler.advice.AopAllianceAnnotationsAuthorizingMethodInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.core.annotation.AnnotationUtils;

public class AuthorizationAttributeSourceAdvisor
extends StaticMethodMatcherPointcutAdvisor {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationAttributeSourceAdvisor.class);
    private static final Class<? extends Annotation>[] AUTHZ_ANNOTATION_CLASSES = new Class[]{RequiresPermissions.class, RequiresRoles.class, RequiresCaptcha.class, RequiresUser.class, RequiresGuest.class, RequiresAuthentication.class};

    public AuthorizationAttributeSourceAdvisor() {
        this.setAdvice((Advice)new AopAllianceAnnotationsAuthorizingMethodInterceptor());
    }

    public boolean matches(Method method, Class targetClass) {
        Method m = method;
        if (this.isAuthzAnnotationPresent(m, targetClass)) {
            return true;
        }
        if (targetClass != null) {
            try {
                m = targetClass.getMethod(m.getName(), m.getParameterTypes());
                if (this.isAuthzAnnotationPresent(m, targetClass)) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isAuthzAnnotationPresent(Method method, Class targetClass) {
        for (Class<? extends Annotation> annClass : AUTHZ_ANNOTATION_CLASSES) {
            Annotation a = AnnotationUtils.findAnnotation((Method)method, annClass);
            if (a != null) {
                return true;
            }
            Annotation b = AnnotationUtils.findAnnotation((Class)targetClass, annClass);
            if (b == null) continue;
            return true;
        }
        return false;
    }
}

