/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe.ann.handler;

import cn.ocoop.framework.safe.SessionManager;
import cn.ocoop.framework.safe.ann.Logical;
import cn.ocoop.framework.safe.ann.RequiresRoles;
import cn.ocoop.framework.safe.ann.handler.AuthenticatedAnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ex.authz.AuthorizingException;
import cn.ocoop.framework.safe.ex.authz.LackPermissionException;
import com.google.common.base.Joiner;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInvocation;

public class RoleAnnotationMethodInterceptor
extends AuthenticatedAnnotationMethodInterceptor {
    public RoleAnnotationMethodInterceptor() {
        super(RequiresRoles.class);
    }

    @Override
    protected void assertAuth(MethodInvocation methodInvocation, Annotation annotation) throws AuthorizingException {
        super.assertAuth(methodInvocation, annotation);
        RequiresRoles requiresRoles = (RequiresRoles)annotation;
        if (requiresRoles.logical() == Logical.AND) {
            if (!SessionManager.hasRole(requiresRoles.value())) {
                throw new LackPermissionException("\u65e0\u6743\u9650,\u9700\u8981" + Joiner.on((String)",").join((Object[])requiresRoles.value()));
            }
            return;
        }
        if (!SessionManager.hasAnyRole(requiresRoles.value())) {
            throw new LackPermissionException("\u65e0\u6743\u9650,\u9700\u8981" + Joiner.on((String)",").join((Object[])requiresRoles.value()));
        }
    }
}

