/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe.ann.handler;

import cn.ocoop.framework.safe.SessionManager;
import cn.ocoop.framework.safe.ann.Logical;
import cn.ocoop.framework.safe.ann.RequiresPermissions;
import cn.ocoop.framework.safe.ann.handler.AuthenticatedAnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ex.authz.AuthorizingException;
import cn.ocoop.framework.safe.ex.authz.LackPermissionException;
import com.google.common.base.Joiner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class PermissionAnnotationMethodInterceptor
extends AuthenticatedAnnotationMethodInterceptor {
    public PermissionAnnotationMethodInterceptor() {
        super(RequiresPermissions.class);
    }

    @Override
    protected void assertAuth(MethodInvocation methodInvocation, Annotation annotation) throws AuthorizingException {
        super.assertAuth(methodInvocation, annotation);
        RequiresPermissions requiresPermissions = (RequiresPermissions)annotation;
        Object[] requiredPmsCode = requiresPermissions.value();
        if (ArrayUtils.isEmpty((Object[])requiredPmsCode)) {
            RequestMapping methodMapping;
            String defaultPmsCode = "";
            RequestMapping controllerMapping = (RequestMapping)AnnotationUtils.findAnnotation(methodInvocation.getThis().getClass(), RequestMapping.class);
            if (controllerMapping != null && ArrayUtils.isNotEmpty((Object[])controllerMapping.value())) {
                defaultPmsCode = defaultPmsCode + Joiner.on((String)",").join((Object[])controllerMapping.value());
            }
            if ((methodMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)methodInvocation.getMethod(), RequestMapping.class)) != null && ArrayUtils.isNotEmpty((Object[])methodMapping.value())) {
                defaultPmsCode = defaultPmsCode + Joiner.on((String)",").join((Object[])methodMapping.value());
            }
            if (StringUtils.isNotBlank((CharSequence)defaultPmsCode)) {
                requiredPmsCode = new String[]{defaultPmsCode};
            }
        }
        if (requiresPermissions.logical() == Logical.AND) {
            if (!SessionManager.hasPermission((String[])requiredPmsCode)) {
                throw new LackPermissionException("\u65e0\u6743\u9650,\u9700\u8981" + Joiner.on((String)",").join(requiredPmsCode));
            }
            return;
        }
        if (!SessionManager.hasAnyPermission((String[])requiredPmsCode)) {
            throw new LackPermissionException("\u65e0\u6743\u9650,\u9700\u8981" + Joiner.on((String)",").join(requiredPmsCode));
        }
    }
}

