/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe.ann.handler;

import cn.ocoop.framework.safe.SessionManager;
import cn.ocoop.framework.safe.WebContext;
import cn.ocoop.framework.safe.ann.RequiresCaptcha;
import cn.ocoop.framework.safe.ann.handler.iface.AbstractAnnotationMethodInterceptor;
import cn.ocoop.framework.safe.ex.authz.AuthorizingException;
import cn.ocoop.framework.safe.ex.authz.InvalidCaptchaException;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;

public class CaptchaAnnotationMethodInterceptor
extends AbstractAnnotationMethodInterceptor {
    public static final String X_CAPTCHA = "X-Captcha";

    public CaptchaAnnotationMethodInterceptor() {
        super(RequiresCaptcha.class);
    }

    @Override
    protected void assertAuth(MethodInvocation methodInvocation, Annotation annotation) throws AuthorizingException {
        String captcha = SessionManager.getAttribute("_captcha");
        if (StringUtils.isBlank((CharSequence)captcha)) {
            throw new InvalidCaptchaException("\u8bf7\u83b7\u53d6\u9a8c\u8bc1\u7801");
        }
        SessionManager.removeAttribute("_captcha");
        String inputCaptcha = WebContext.get().getRequest().getHeader(X_CAPTCHA);
        if (!captcha.equalsIgnoreCase(inputCaptcha)) {
            throw new InvalidCaptchaException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
    }
}

