/*
 * Decompiled with CFR 0.152.
 */
package cn.ocoop.framework.safe;

import cn.ocoop.framework.safe.SafeProperties;
import cn.ocoop.framework.safe.WebContext;
import cn.ocoop.framework.safe.auth.service.AuthorizingService;
import cn.ocoop.framework.safe.utils.CookieUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;

public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    public static SafeProperties safeProperties;
    public static StringRedisTemplate redisTemplate;
    public static AuthorizingService authorizingService;

    public static BoundHashOperations<String, String, String> getSession(String sessionId) {
        return redisTemplate.boundHashOps((Object)SessionManager.getSessionkey(sessionId));
    }

    public static BoundHashOperations<String, String, String> getSession() {
        return redisTemplate.boundHashOps((Object)SessionManager.getSessionkey(WebContext.get().getSessionId()));
    }

    public static List<BoundHashOperations<String, String, String>> getSession(long accountId) {
        Set keys = redisTemplate.keys((Object)SessionManager.getSessionMapKey(accountId, "*"));
        ArrayList sessions = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            for (String key : keys) {
                sessions.add(SessionManager.getSession((String)redisTemplate.opsForValue().get((Object)key)));
            }
        }
        return sessions;
    }

    public static void setAttribute(long accountId, String key, String value) {
        for (BoundHashOperations<String, String, String> session : SessionManager.getSession(accountId)) {
            session.put((Object)key, (Object)value);
        }
    }

    public static void removeAttribute(long accountId, String key) {
        for (BoundHashOperations<String, String, String> session : SessionManager.getSession(accountId)) {
            session.delete(new Object[]{key});
        }
    }

    public static String createSessionId() {
        return UUID.randomUUID().toString();
    }

    public static void setAttribute(String key, String value) {
        SessionManager.getSession().put((Object)key, (Object)value);
    }

    public static String getAttribute(String key) {
        return (String)SessionManager.getSession().get((Object)key);
    }

    public static void removeAttribute(String key) {
        SessionManager.getSession().delete(new Object[]{key});
    }

    public static void logout(HttpServletResponse response) {
        SessionManager.getCurrentAccountId().ifPresent(accountId -> {
            redisTemplate.delete((Collection)Lists.newArrayList((Object[])new String[]{WebContext.get().getSessionId(), SessionManager.getSessionMapKey(accountId, WebContext.get().getSessionId()), SessionManager.getRoleKey(accountId), SessionManager.getPmsKey(accountId)}));
            CookieUtils.clear(response, safeProperties.getSession().getSessionIdCookieName());
        });
    }

    private static BoundHashOperations<String, String, String> createSession(HttpServletResponse response, String sessionId, Long accountId) {
        BoundHashOperations hash = redisTemplate.boundHashOps((Object)SessionManager.getSessionkey(sessionId));
        hash.put((Object)"_id", (Object)sessionId);
        hash.expire(2L, TimeUnit.DAYS);
        if (accountId != null) {
            hash.put((Object)"accountId", (Object)String.valueOf(accountId));
            redisTemplate.opsForValue().set((Object)SessionManager.getSessionMapKey(accountId, sessionId), (Object)sessionId, 2L, TimeUnit.DAYS);
        }
        CookieUtils.store(response, safeProperties.getSession().getSessionIdCookieName(), sessionId);
        return hash;
    }

    public static BoundHashOperations<String, String, String> createSession(HttpServletResponse response, String sessionId) {
        return SessionManager.createSession(response, sessionId, null);
    }

    public static BoundHashOperations<String, String, String> createAuthenticatedSession(HttpServletResponse response, Long accountId) {
        BoundHashOperations<String, String, String> lastSession = SessionManager.getSession();
        BoundHashOperations<String, String, String> session = SessionManager.createSession(response, SessionManager.createSessionId(), accountId);
        Map entries = lastSession.entries();
        if (entries != null) {
            for (String key : entries.keySet()) {
                if ("accountId".equals(key) || "_id".equals(key) || entries.get(key) == null) continue;
                session.put((Object)key, entries.get(key));
            }
        }
        SessionManager.clearLastSession(accountId, WebContext.get().getSessionId());
        return session;
    }

    private static void clearLastSession(Long accountId, String sessionId) {
        redisTemplate.delete((Object)SessionManager.getSessionkey(sessionId));
        if (accountId != null) {
            redisTemplate.delete((Object)SessionManager.getSessionMapKey(accountId, sessionId));
        }
    }

    private static String getSessionkey(String sessionId) {
        return safeProperties.getSession().getSessionKeyPrefix() + sessionId;
    }

    private static String getSessionMapKey(long accountId, String sessionId) {
        return safeProperties.getSession().getSessionMapKeyPrefix() + accountId + ":" + sessionId;
    }

    public static boolean isLogin(String sessionId) {
        BoundHashOperations<String, String, String> session = SessionManager.getSession(sessionId);
        return StringUtils.isNotBlank((CharSequence)((CharSequence)session.get((Object)"accountId")));
    }

    public static boolean isLogin() {
        BoundHashOperations<String, String, String> session = SessionManager.getSession();
        return StringUtils.isNotBlank((CharSequence)((CharSequence)session.get((Object)"accountId")));
    }

    public static boolean touch(String sessionId) {
        Boolean expire = redisTemplate.expire((Object)SessionManager.getSessionkey(sessionId), 2L, TimeUnit.DAYS);
        if (BooleanUtils.isNotTrue((Boolean)expire)) {
            return false;
        }
        if (!SessionManager.isLogin(sessionId)) {
            return true;
        }
        redisTemplate.opsForValue().set((Object)SessionManager.getSessionMapKey(NumberUtils.toLong((String)((String)SessionManager.getSession(sessionId).get((Object)"accountId"))), sessionId), (Object)sessionId, 2L, TimeUnit.DAYS);
        return true;
    }

    private static String getPmsKey(long accountId) {
        return "permissions:account_id:" + accountId;
    }

    private static String getRoleKey(long accountId) {
        return "roles:account_id:" + accountId;
    }

    public static Optional<Long> getCurrentAccountId() {
        BoundHashOperations<String, String, String> session = SessionManager.getSession(WebContext.get().getSessionId());
        if (StringUtils.isBlank((CharSequence)((CharSequence)session.get((Object)"accountId")))) {
            return Optional.empty();
        }
        return Optional.of(NumberUtils.toLong((String)((String)session.get((Object)"accountId"))));
    }

    public static void clearRoleAndPermission() {
        redisTemplate.delete((Object)safeProperties.getSession().getPermissionKey());
    }

    public static void clearRoleAndPermission(long accountId) {
        redisTemplate.opsForHash().delete((Object)safeProperties.getSession().getPermissionKey(), new Object[]{SessionManager.getPmsKey(accountId), SessionManager.getRoleKey(accountId)});
    }

    public static void clearRole(long accountId) {
        redisTemplate.opsForHash().delete((Object)safeProperties.getSession().getPermissionKey(), new Object[]{SessionManager.getRoleKey(accountId)});
    }

    public static void clearPermission(long accountId) {
        redisTemplate.opsForHash().delete((Object)safeProperties.getSession().getPermissionKey(), new Object[]{SessionManager.getPmsKey(accountId)});
    }

    public static List<String> getPermission() {
        String pmsKey;
        Optional<Long> AccountIdOptional = SessionManager.getCurrentAccountId();
        if (!AccountIdOptional.isPresent()) {
            return Lists.newArrayList();
        }
        BoundHashOperations pmsStore = redisTemplate.boundHashOps((Object)safeProperties.getSession().getPermissionKey());
        if (BooleanUtils.isNotTrue((Boolean)pmsStore.hasKey((Object)(pmsKey = SessionManager.getPmsKey(AccountIdOptional.get()))))) {
            ArrayList pms = authorizingService.listPermission(AccountIdOptional.get());
            if (CollectionUtils.isEmpty(pms)) {
                pms = Lists.newArrayList();
            }
            pmsStore.put((Object)pmsKey, (Object)JSON.toJSONString((Object)pms));
        }
        return (List)JSON.parseObject((String)((String)pmsStore.get((Object)pmsKey)), List.class);
    }

    public static List<String> getRole() {
        String roleKey;
        Optional<Long> AccountIdOptional = SessionManager.getCurrentAccountId();
        if (!AccountIdOptional.isPresent()) {
            return Lists.newArrayList();
        }
        BoundHashOperations roleStore = redisTemplate.boundHashOps((Object)safeProperties.getSession().getPermissionKey());
        if (BooleanUtils.isNotTrue((Boolean)roleStore.hasKey((Object)(roleKey = SessionManager.getRoleKey(AccountIdOptional.get()))))) {
            ArrayList pms = authorizingService.listRole(AccountIdOptional.get());
            if (CollectionUtils.isEmpty(pms)) {
                pms = Lists.newArrayList();
            }
            roleStore.put((Object)roleKey, (Object)JSON.toJSONString((Object)pms));
        }
        return (List)JSON.parseObject((String)((String)roleStore.get((Object)roleKey)), List.class);
    }

    public static boolean hasRole(String ... role) {
        return SessionManager.getRole().containsAll(Arrays.asList(role));
    }

    public static boolean hasAnyRole(String ... role) {
        List<String> role1 = SessionManager.getRole();
        return Stream.of(role).anyMatch(role1::contains);
    }

    public static boolean hasPermission(String ... pms) {
        return SessionManager.getPermission().containsAll(Arrays.asList(pms));
    }

    public static boolean hasAnyPermission(String ... pms) {
        List<String> pms1 = SessionManager.getPermission();
        return Stream.of(pms).anyMatch(pms1::contains);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionManager)) {
            return false;
        }
        SessionManager other = (SessionManager)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SessionManager;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "SessionManager()";
    }
}

