/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common.compress;

import cn.nxtools.common.ArrayUtil;
import cn.nxtools.common.BooleanUtil;
import cn.nxtools.common.FileUtil;
import cn.nxtools.common.IOUtil;
import cn.nxtools.common.StringUtil;
import cn.nxtools.common.base.Objects;
import cn.nxtools.common.exception.IORuntimeException;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipWriter
implements Closeable {
    private final ZipOutputStream zipOutput;

    public static ZipWriter open(File zipFile, Charset charset) {
        return new ZipWriter(zipFile, charset);
    }

    public static ZipWriter open(OutputStream output, Charset charset) {
        return new ZipWriter(output, charset);
    }

    public ZipWriter(File zipFile, Charset charset) {
        this.zipOutput = ZipWriter.getZipOutputStream(zipFile, charset);
    }

    public ZipWriter(OutputStream output, Charset charset) {
        this.zipOutput = ZipWriter.getZipOutputStream(output, charset);
    }

    public ZipWriter(ZipOutputStream output) {
        this.zipOutput = output;
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        return ZipWriter.getZipOutputStream(FileUtil.openOutputStream(zipFile, true), charset);
    }

    private static ZipOutputStream getZipOutputStream(OutputStream outputStream, Charset charset) {
        if (outputStream instanceof ZipOutputStream) {
            return (ZipOutputStream)outputStream;
        }
        return new ZipOutputStream(outputStream, charset);
    }

    public ZipWriter setLevel(int level) {
        this.zipOutput.setLevel(level);
        return this;
    }

    public ZipWriter setComment(String comment) {
        this.zipOutput.setComment(comment);
        return this;
    }

    public ZipOutputStream getZipOutput() {
        return this.zipOutput;
    }

    public ZipWriter add(boolean includeSrcDir, FileFilter filter, File ... files) {
        if (Objects.isNull(files)) {
            return this;
        }
        for (File file : files) {
            String rootDir = "";
            try {
                rootDir = file.getCanonicalPath();
                if (BooleanUtil.isFalse(file.isDirectory()) || includeSrcDir) {
                    rootDir = file.getCanonicalFile().getParentFile().getCanonicalPath();
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            this.add(file, rootDir, filter);
        }
        return this;
    }

    public ZipWriter add(String path, InputStream in) {
        path = Objects.defaultIfNull(path, "");
        if (in == null && !path.endsWith(File.separator) && StringUtil.isNull(path = path.concat(File.separator))) {
            return this;
        }
        return this.putEntry(path, in);
    }

    private ZipWriter add(File file, String rootDir, FileFilter filter) {
        if (Objects.isNull(file) || Objects.nonNull(filter) && !filter.accept(file)) {
            return this;
        }
        String subPath = FileUtil.getCanonicalPath(file).replaceFirst(rootDir, "");
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (ArrayUtil.isEmpty(files)) {
                this.add(subPath, null);
            } else {
                for (File childrenFile : files) {
                    this.add(childrenFile, rootDir, filter);
                }
            }
        } else {
            this.putEntry(subPath, FileUtil.openInputStream(file));
        }
        return this;
    }

    private ZipWriter putEntry(String path, InputStream in) {
        try {
            this.zipOutput.putNextEntry(new ZipEntry(path));
            if (in != null) {
                IOUtil.copy(in, (OutputStream)this.zipOutput);
            }
            this.zipOutput.closeEntry();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)in);
        }
        IOUtil.flushQuietly(this.zipOutput);
        return this;
    }

    @Override
    public void close() {
        try {
            this.zipOutput.finish();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)this.zipOutput);
        }
    }
}

