/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common.collect;

import cn.nxtools.common.base.Preconditions;
import cn.nxtools.common.collect.Iterables;
import cn.nxtools.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public final class Sets {
    private Sets() {
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(E ... elements) {
        Preconditions.checkNotNull(elements);
        HashSet hashSet = new HashSet(elements.length);
        Collections.addAll(hashSet, elements);
        return hashSet;
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        HashSet<E> set = Sets.newHashSet();
        Iterables.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> newHashSet(Iterator<? extends E> elements) {
        HashSet<E> set = Sets.newHashSet();
        Iterators.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> newHashSetWithSize(int size) {
        return new HashSet(size);
    }

    public static <E> Set<E> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static <E> Set<E> newConcurrentHashSet(E ... elements) {
        Preconditions.checkNotNull(elements);
        Set<E> set = Sets.newConcurrentHashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> Set<E> newConcurrentHashSet(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        Set<E> set = Sets.newConcurrentHashSet();
        Iterables.addAll(set, elements);
        return set;
    }

    public static <E> Set<E> newConcurrentHashSet(Iterator<? extends E> elements) {
        Set<E> set = Sets.newConcurrentHashSet();
        Iterators.addAll(set, elements);
        return set;
    }

    public static <E> Set<E> newConcurrentHashSet(int size) {
        return Collections.newSetFromMap(new ConcurrentHashMap(size));
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(E ... elements) {
        Preconditions.checkNotNull(elements);
        return new LinkedHashSet<E>(Arrays.asList(elements));
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        LinkedHashSet<E> set = Sets.newLinkedHashSet();
        Iterables.addAll(set, elements);
        return set;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterator<? extends E> elements) {
        LinkedHashSet<E> set = Sets.newLinkedHashSet();
        Iterators.addAll(set, elements);
        return set;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(int size) {
        return new LinkedHashSet(size);
    }

    public static <E> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E> TreeSet<E> newTreeSet(E ... elements) {
        Preconditions.checkNotNull(elements);
        return new TreeSet<E>(Arrays.asList(elements));
    }

    public static <E> TreeSet<E> newTreeSet(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        TreeSet<E> set = Sets.newTreeSet();
        Iterables.addAll(set, elements);
        return set;
    }

    public static <E> TreeSet<E> newTreeSet(Iterator<? extends E> elements) {
        TreeSet<E> set = Sets.newTreeSet();
        Iterators.addAll(set, elements);
        return set;
    }
}

