/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common.collect;

import cn.nxtools.common.base.Preconditions;
import cn.nxtools.common.collect.Iterables;
import cn.nxtools.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public final class Lists {
    private Lists() {
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(E ... elements) {
        Preconditions.checkNotNull(elements);
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        ArrayList<E> list = Lists.newArrayList();
        Iterables.addAll(list, elements);
        return list;
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        ArrayList<E> list = Lists.newArrayList();
        Iterators.addAll(list, elements);
        return list;
    }

    public static <E> ArrayList<E> newArrayListWithSize(int size) {
        return new ArrayList(size);
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> LinkedList<E> newLinkedList(E ... elements) {
        Preconditions.checkNotNull(elements);
        return new LinkedList<E>(Arrays.asList(elements));
    }

    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        LinkedList<E> list = Lists.newLinkedList();
        Iterables.addAll(list, elements);
        return list;
    }

    public static <E> LinkedList<E> newLinkedList(Iterator<? extends E> elements) {
        LinkedList<E> list = Lists.newLinkedList();
        Iterators.addAll(list, elements);
        return list;
    }
}

