/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common.base;

import cn.nxtools.common.base.Preconditions;
import cn.nxtools.common.base.Ticker;
import java.util.concurrent.TimeUnit;

public final class Stopwatch {
    private final Ticker ticker = Ticker.nanoTicker();
    private boolean isRunning;
    private long elapsedNanos;
    private long startNanos;
    private long totalElapsedNanos;

    private Stopwatch() {
    }

    public static Stopwatch createStarted() {
        return new Stopwatch().start();
    }

    public Stopwatch start() {
        Preconditions.checkState(!this.isRunning, "This Stopwatch is already running");
        this.isRunning = true;
        this.startNanos = this.ticker.read();
        return this;
    }

    public Stopwatch stop() {
        long nanos = this.ticker.read();
        Preconditions.checkState(this.isRunning, "This Stopwatch is already stopped");
        this.isRunning = false;
        this.elapsedNanos += nanos - this.startNanos;
        return this;
    }

    public Stopwatch reset() {
        if (this.isRunning) {
            this.totalElapsedNanos += this.ticker.read() - this.startNanos + this.elapsedNanos;
        }
        this.isRunning = false;
        this.elapsedNanos = 0L;
        return this;
    }

    public Stopwatch resetAndStart() {
        this.reset().start();
        return this;
    }

    public long elapsed(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    private long elapsedNanos() {
        return this.isRunning ? this.ticker.read() - this.startNanos + this.elapsedNanos : this.elapsedNanos;
    }

    public long totalElapsed(TimeUnit timeUnit) {
        return timeUnit.convert(this.totalElapsedNanos + this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public String toString() {
        long nanos = this.elapsedNanos();
        TimeUnit timeUnit = Stopwatch.chooseUnit(nanos);
        double v = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        return String.format("%.6f%s", v, Stopwatch.timeUnitAbbreviate(timeUnit));
    }

    public String totalToString() {
        long nanos = this.totalElapsedNanos + this.elapsedNanos();
        TimeUnit timeUnit = Stopwatch.chooseUnit(nanos);
        double v = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        return String.format("%.6f%s", v, Stopwatch.timeUnitAbbreviate(timeUnit));
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String timeUnitAbbreviate(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError();
    }
}

