/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common.base;

import cn.nxtools.common.CollectionUtil;
import cn.nxtools.common.StringUtil;
import cn.nxtools.common.base.Objects;
import cn.nxtools.common.base.Preconditions;
import cn.nxtools.common.collect.Lists;
import cn.nxtools.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Splitter {
    private final String separator;

    private Splitter(String separator) {
        Preconditions.checkState(StringUtil.isNotEmpty(separator), "The separator may not be null or empty string");
        this.separator = separator;
    }

    public static Splitter on(String separator) {
        return new Splitter(separator);
    }

    public static Splitter on(char separator) {
        return new Splitter(String.valueOf(separator));
    }

    public final List<String> splitToList(String str) {
        return this.splitWork(str);
    }

    public final String[] split(String str) {
        List<String> list = this.splitWork(str);
        if (Objects.isNull(list)) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public final Stream<String> splitToStream(String str) {
        List<String> list = this.splitWork(str);
        if (Objects.isNull(list)) {
            return null;
        }
        return StreamSupport.stream(list.spliterator(), false);
    }

    private final List<String> splitWork(String str) {
        int i;
        if (Objects.isNull(str)) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return Lists.newArrayList();
        }
        ArrayList<String> list = Lists.newArrayList();
        int startIndex = 0;
        if (this.separator.length() == 1) {
            char sep = this.separator.charAt(0);
            while (i < length) {
                if (str.charAt(i) == sep) {
                    list.add(str.substring(startIndex, i));
                    startIndex = ++i;
                    continue;
                }
                ++i;
            }
        } else {
            int seqLength = this.separator.length();
            for (i = 0; i < length; ++i) {
                boolean match = true;
                for (int j = 0; j < seqLength; ++j) {
                    if (this.separator.charAt(j) == str.charAt(i + j)) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                list.add(str.substring(startIndex, i));
                startIndex = i + seqLength;
            }
        }
        list.add(str.substring(startIndex, length));
        return list;
    }

    public final MapSplitter withKeyValueSeparator(String separator) {
        return new MapSplitter(this, Splitter.on(separator));
    }

    public final MapSplitter withKeyValueSeparator(char separator) {
        return new MapSplitter(this, Splitter.on(separator));
    }

    public static final class MapSplitter {
        private final Splitter outerSplitter;
        private final Splitter innerSplitter;

        private MapSplitter(Splitter outerSplitter, Splitter innerSplitter) {
            this.outerSplitter = outerSplitter;
            this.innerSplitter = innerSplitter;
        }

        public Map<String, String> split(String str) {
            LinkedHashMap<String, String> map = Maps.newLinkedHashMap();
            List<String> list = this.outerSplitter.splitToList(str);
            if (CollectionUtil.isEmpty(list)) {
                return Collections.unmodifiableMap(map);
            }
            for (String s : list) {
                List<String> mapList = this.innerSplitter.splitToList(s);
                Preconditions.checkState(CollectionUtil.isNotEmpty(mapList) && mapList.size() == 2, String.format("data [%s] is not a valid entry", s));
                String key = mapList.get(0);
                Preconditions.checkState(!map.containsKey(key), String.format("Duplicate key [%s] found.", key));
                map.put(key, mapList.get(1));
            }
            return Collections.unmodifiableMap(map);
        }
    }
}

