/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common.base;

import java.util.function.Supplier;

public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T> T checkNotNull(T t, String errorMsg) {
        if (t == null) {
            throw new NullPointerException(errorMsg);
        }
        return t;
    }

    public static <T, X extends Throwable> T checkNotNull(T t, Supplier<? extends X> exceptionSupplier) throws X {
        if (t == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return t;
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, String errorMsg) {
        if (!expression) {
            throw new IllegalStateException(errorMsg);
        }
    }

    public static <X extends Throwable> void checkState(boolean expression, Supplier<? extends X> exceptionSupplier) throws X {
        if (!expression) {
            throw (Throwable)exceptionSupplier.get();
        }
    }
}

