/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common.base;

import cn.nxtools.common.base.Preconditions;
import java.util.function.Function;

public final class Objects {
    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean nonNull(Object obj) {
        return obj != null;
    }

    public static <T> T defaultIfNull(T obj, T defaultValue) {
        return obj == null ? defaultValue : obj;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 != null && o1.equals(o2);
    }

    public static <T, U> U map(T obj, Function<? super T, ? extends U> mapper) {
        return Objects.map(obj, mapper, null);
    }

    public static <T, U> U map(T obj, Function<? super T, ? extends U> mapper, U defaultValue) {
        Preconditions.checkNotNull(mapper, "mapper must not be null");
        if (obj == null) {
            return defaultValue;
        }
        return mapper.apply(obj);
    }
}

