/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common.base;

import cn.nxtools.common.base.Objects;
import cn.nxtools.common.base.Preconditions;
import cn.nxtools.common.collect.Iterables;
import cn.nxtools.common.collect.Lists;
import java.util.Iterator;
import java.util.StringJoiner;

public class Joiner {
    private final String separator;

    private Joiner(String separator) {
        this.separator = Objects.isNull(separator) ? "" : separator;
    }

    public static Joiner on(String separator) {
        return new Joiner(separator);
    }

    public static Joiner on(char separator) {
        return new Joiner(String.valueOf(separator));
    }

    public final <T> String join(T ... elements) {
        if (Objects.isNull(elements)) {
            return null;
        }
        return this.join((Object[])elements, 0, elements.length);
    }

    public final String join(Object[] objects, int startIndex, int endIndex) {
        if (Objects.isNull(objects)) {
            return null;
        }
        return this.join((Iterable<?>)Lists.newArrayList(objects), startIndex, endIndex);
    }

    public final String join(Iterable<?> iterable) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        int size = Iterables.size(iterable);
        return this.join(iterable, 0, size);
    }

    public final String join(Iterable<?> iterable, int startIndex, int endIndex) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        return this.join(iterable.iterator(), startIndex, endIndex);
    }

    public final String join(Iterator<?> iterator, int startIndex, int endIndex) {
        if (Objects.isNull(iterator)) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return "";
        }
        StringJoiner stringJoiner = this.newStringJoiner();
        int index = -1;
        while (iterator.hasNext()) {
            if (++index < startIndex) {
                iterator.next();
                continue;
            }
            if (index >= endIndex) break;
            stringJoiner.add(this.toString(iterator.next()));
        }
        return stringJoiner.toString();
    }

    CharSequence toString(Object obj) {
        Preconditions.checkNotNull(obj);
        return obj instanceof CharSequence ? (CharSequence)obj : obj.toString();
    }

    private StringJoiner newStringJoiner() {
        return new StringJoiner(this.separator);
    }

    public final String join(int[] array) {
        if (Objects.isNull(array)) {
            return null;
        }
        return this.join(array, 0, array.length);
    }

    public final String join(int[] array, int startIndex, int endIndex) {
        if (Objects.isNull(array)) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return "";
        }
        StringJoiner stringJoiner = this.newStringJoiner();
        for (int i = startIndex; i < endIndex; ++i) {
            stringJoiner.add(String.valueOf(array[i]));
        }
        return stringJoiner.toString();
    }

    public final String join(byte[] array) {
        if (Objects.isNull(array)) {
            return null;
        }
        return this.join(array, 0, array.length);
    }

    public final String join(byte[] array, int startIndex, int endIndex) {
        if (Objects.isNull(array)) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return "";
        }
        StringJoiner stringJoiner = this.newStringJoiner();
        for (int i = startIndex; i < endIndex; ++i) {
            stringJoiner.add(String.valueOf(array[i]));
        }
        return stringJoiner.toString();
    }

    public final String join(long[] array) {
        if (Objects.isNull(array)) {
            return null;
        }
        return this.join(array, 0, array.length);
    }

    public final String join(long[] array, int startIndex, int endIndex) {
        if (Objects.isNull(array)) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return "";
        }
        StringJoiner stringJoiner = this.newStringJoiner();
        for (int i = startIndex; i < endIndex; ++i) {
            stringJoiner.add(String.valueOf(array[i]));
        }
        return stringJoiner.toString();
    }

    public final String join(double[] array) {
        if (Objects.isNull(array)) {
            return null;
        }
        return this.join(array, 0, array.length);
    }

    public final String join(double[] array, int startIndex, int endIndex) {
        if (Objects.isNull(array)) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return "";
        }
        StringJoiner stringJoiner = this.newStringJoiner();
        for (int i = startIndex; i < endIndex; ++i) {
            stringJoiner.add(String.valueOf(array[i]));
        }
        return stringJoiner.toString();
    }

    public final String join(float[] array) {
        if (Objects.isNull(array)) {
            return null;
        }
        return this.join(array, 0, array.length);
    }

    public final String join(float[] array, int startIndex, int endIndex) {
        if (Objects.isNull(array)) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return "";
        }
        StringJoiner stringJoiner = this.newStringJoiner();
        for (int i = startIndex; i < endIndex; ++i) {
            stringJoiner.add(String.valueOf(array[i]));
        }
        return stringJoiner.toString();
    }

    public final String join(short[] array) {
        if (Objects.isNull(array)) {
            return null;
        }
        return this.join(array, 0, array.length);
    }

    public final String join(short[] array, int startIndex, int endIndex) {
        if (Objects.isNull(array)) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return "";
        }
        StringJoiner stringJoiner = this.newStringJoiner();
        for (int i = startIndex; i < endIndex; ++i) {
            stringJoiner.add(String.valueOf(array[i]));
        }
        return stringJoiner.toString();
    }

    public final String join(boolean[] array) {
        if (Objects.isNull(array)) {
            return null;
        }
        return this.join(array, 0, array.length);
    }

    public final String join(boolean[] array, int startIndex, int endIndex) {
        if (Objects.isNull(array)) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return "";
        }
        StringJoiner stringJoiner = this.newStringJoiner();
        for (int i = startIndex; i < endIndex; ++i) {
            stringJoiner.add(String.valueOf(array[i]));
        }
        return stringJoiner.toString();
    }

    public final String join(char[] array) {
        if (Objects.isNull(array)) {
            return null;
        }
        return this.join(array, 0, array.length);
    }

    public final String join(char[] array, int startIndex, int endIndex) {
        if (Objects.isNull(array)) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return "";
        }
        StringJoiner stringJoiner = this.newStringJoiner();
        for (int i = startIndex; i < endIndex; ++i) {
            stringJoiner.add(String.valueOf(array[i]));
        }
        return stringJoiner.toString();
    }
}

