/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.ArrayUtil;
import cn.nxtools.common.BooleanUtil;
import cn.nxtools.common.FileUtil;
import cn.nxtools.common.FilenameUtil;
import cn.nxtools.common.compress.ZipWriter;
import cn.nxtools.common.exception.FileException;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();

    private ZipUtil() {
    }

    public static File zip(String srcPath) {
        return ZipUtil.zip(srcPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, Charset charset) {
        return ZipUtil.zip(new File(srcPath), charset);
    }

    public static File zip(String srcPath, String zipPath) {
        return ZipUtil.zip(srcPath, zipPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, String zipPath, Charset charset) {
        return ZipUtil.zip(new File(srcPath), new File(zipPath), charset);
    }

    public static File zip(File srcFile) {
        return ZipUtil.zip(srcFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, Charset charset) {
        String zipPath = FileUtil.getCanonicalPath(srcFile.getParentFile()) + File.separator + FilenameUtil.getBaseName(FileUtil.getCanonicalPath(srcFile)) + ".zip";
        File zipFile = new File(zipPath);
        return ZipUtil.zip(srcFile, zipFile, charset);
    }

    public static File zip(File srcFile, File zipFile) {
        return ZipUtil.zip(srcFile, zipFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, File zipFile, Charset charset) {
        return ZipUtil.zip(srcFile, zipFile, charset, false);
    }

    public static File zip(File srcFile, File zipFile, Charset charset, boolean includeSrcDir) {
        return ZipUtil.zip(zipFile, charset, includeSrcDir, srcFile);
    }

    public static File zip(File zipFile, Charset charset, boolean includeSrcDir, File ... srcFiles) {
        return ZipUtil.zip(zipFile, charset, includeSrcDir, null, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean includeSrcDir, FileFilter filter, File ... srcFiles) {
        ZipUtil.checkFiles(zipFile, srcFiles);
        try (ZipWriter zipWriter = ZipWriter.open(zipFile, charset);){
            zipWriter.add(includeSrcDir, filter, srcFiles);
        }
        return zipFile;
    }

    public static File zip(String srcPath, InputStream in, File zipFile) {
        return ZipUtil.zip(srcPath, in, zipFile, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, InputStream in, File zipFile, Charset charset) {
        return ZipUtil.zip(new String[]{srcPath}, new InputStream[]{in}, zipFile, charset);
    }

    public static File zip(String[] srcPaths, InputStream[] ins, File zipFile) {
        return ZipUtil.zip(srcPaths, ins, zipFile, DEFAULT_CHARSET);
    }

    public static File zip(String[] srcPaths, InputStream[] ins, File zipFile, Charset charset) {
        if (ArrayUtil.isEmpty(srcPaths) || ArrayUtil.isEmpty(ins)) {
            throw new IllegalArgumentException("srcPaths or ins is empty");
        }
        if (srcPaths.length != ins.length) {
            throw new IllegalArgumentException("srcPaths length is not equal to ins length");
        }
        try (ZipWriter zipWriter = ZipWriter.open(zipFile, charset);){
            for (int i = 0; i < srcPaths.length; ++i) {
                zipWriter.add(srcPaths[i], ins[i]);
            }
        }
        return zipFile;
    }

    public static void zip(OutputStream output, String[] srcPaths, InputStream[] ins) {
        ZipUtil.zip(output, srcPaths, ins, DEFAULT_CHARSET);
    }

    public static void zip(OutputStream output, String[] srcPaths, InputStream[] ins, Charset charset) {
        if (ArrayUtil.isEmpty(srcPaths) || ArrayUtil.isEmpty(ins)) {
            throw new IllegalArgumentException("srcPaths or ins is empty");
        }
        if (srcPaths.length != ins.length) {
            throw new IllegalArgumentException("srcPaths length is not equal to ins length");
        }
        try (ZipWriter zipWriter = ZipWriter.open(output, charset);){
            for (int i = 0; i < srcPaths.length; ++i) {
                zipWriter.add(srcPaths[i], ins[i]);
            }
        }
    }

    public static void zip(ZipOutputStream zipOutput, String[] srcPaths, InputStream[] ins) {
        ZipUtil.zip(zipOutput, srcPaths, ins, DEFAULT_CHARSET);
    }

    public static void zip(ZipOutputStream zipOutput, String[] srcPaths, InputStream[] ins, Charset charset) {
        if (ArrayUtil.isEmpty(srcPaths) || ArrayUtil.isEmpty(ins)) {
            throw new IllegalArgumentException("srcPaths or ins is empty");
        }
        if (srcPaths.length != ins.length) {
            throw new IllegalArgumentException("srcPaths length is not equal to ins length");
        }
        try (ZipWriter zipWriter = ZipWriter.open(zipOutput, charset);){
            for (int i = 0; i < srcPaths.length; ++i) {
                zipWriter.add(srcPaths[i], ins[i]);
            }
        }
    }

    private static void checkFiles(File zipFile, File ... srcFiles) {
        if (zipFile.isDirectory()) {
            throw new FileException("Zip file {} must not be a directory ", zipFile);
        }
        for (File srcFile : srcFiles) {
            if (srcFile == null) continue;
            if (BooleanUtil.isFalse(srcFile.exists())) {
                throw new FileException("File {} not exist ", srcFile);
            }
            if (!srcFile.isDirectory() || !FileUtil.isSub(srcFile, zipFile.getParentFile())) continue;
            throw new FileException("Zip file path {} must not be the child directory of {}", zipFile, srcFile);
        }
    }
}

