/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.ArrayUtil;
import cn.nxtools.common.base.Objects;
import cn.nxtools.common.text.StringPool;
import java.util.Arrays;

public class StringUtil
implements StringPool {
    private StringUtil() {
    }

    public static boolean isNull(CharSequence charSequence) {
        return charSequence == null;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || "".equals(charSequence);
    }

    public static boolean isNotNull(CharSequence charSequence) {
        return charSequence != null;
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return charSequence != null && !"".equals(charSequence);
    }

    public static String format(String template, Object ... params) {
        return StringUtil.formatWith(template, "{}", params);
    }

    public static String formatWith(String template, String placeholder, Object ... params) {
        int placeholderStart;
        if (StringUtil.isNull(template)) {
            return "null";
        }
        if (StringUtil.isNull(placeholder)) {
            throw new IllegalArgumentException("string format placeholder cannot be null or empty");
        }
        if ("".equals(placeholder)) {
            return template;
        }
        if (ArrayUtil.isEmpty(params)) {
            return template;
        }
        for (int i = 0; i < params.length; ++i) {
            params[i] = StringUtil.objToString(params[i]);
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * params.length);
        int templateStart = 0;
        int i = 0;
        while (i < params.length && (placeholderStart = template.indexOf(placeholder, templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(params[i++]);
            templateStart = placeholderStart + placeholder.length();
        }
        builder.append(template, templateStart, template.length());
        if (i < params.length) {
            builder.append(" [");
            builder.append(params[i++]);
            while (i < params.length) {
                builder.append(", ");
                builder.append(params[i++]);
            }
            builder.append("]");
        }
        return builder.toString();
    }

    public static String objToString(Object o) {
        if (Objects.isNull(o)) {
            return "null";
        }
        return o.toString();
    }

    public static int length(CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    public static <T extends CharSequence> T defaultIfNull(T string, T defaultString) {
        return StringUtil.isNull(string) ? defaultString : string;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T string, T defaultString) {
        return StringUtil.isEmpty(string) ? defaultString : string;
    }

    public static String leftAppend(String str, int size, char appendChar) {
        if (StringUtil.isNull(str)) {
            return null;
        }
        int append = size - str.length();
        if (append <= 0) {
            return str;
        }
        char[] buf = new char[append];
        Arrays.fill(buf, appendChar);
        return new String(buf).concat(str);
    }

    public static String leftAppend(String str, int size, String appendStr) {
        if (StringUtil.isNull(str)) {
            return null;
        }
        if (StringUtil.isNull(appendStr)) {
            throw new IllegalArgumentException("appendStr must not be null");
        }
        if (StringUtil.isEmpty(appendStr)) {
            return str;
        }
        int appendStrLen = appendStr.length();
        int strLen = str.length();
        int append = size - strLen;
        if (append <= 0) {
            return str;
        }
        if (appendStrLen == 1) {
            return StringUtil.leftAppend(str, strLen, appendStr.charAt(0));
        }
        if (append == appendStrLen) {
            return appendStr.concat(str);
        }
        if (append < appendStrLen) {
            return appendStr.substring(0, append).concat(str);
        }
        char[] padding = new char[append];
        char[] padChars = appendStr.toCharArray();
        for (int i = 0; i < append; ++i) {
            padding[i] = padChars[i % appendStrLen];
        }
        return new String(padding).concat(str);
    }

    public static String rightAppend(String str, int size, char appendChar) {
        if (StringUtil.isNull(str)) {
            return null;
        }
        int append = size - str.length();
        if (append <= 0) {
            return str;
        }
        char[] buf = new char[append];
        Arrays.fill(buf, appendChar);
        return str.concat(new String(buf));
    }

    public static String rightAppend(String str, int size, String appendStr) {
        if (StringUtil.isNull(str)) {
            return null;
        }
        if (StringUtil.isNull(appendStr)) {
            throw new IllegalArgumentException("appendStr must not be null");
        }
        if (StringUtil.isEmpty(appendStr)) {
            return str;
        }
        int appendStrLen = appendStr.length();
        int strLen = str.length();
        int append = size - strLen;
        if (append <= 0) {
            return str;
        }
        if (appendStrLen == 1) {
            return StringUtil.rightAppend(str, strLen, appendStr.charAt(0));
        }
        if (append == appendStrLen) {
            return str.concat(appendStr);
        }
        if (append < appendStrLen) {
            return str.concat(appendStr.substring(0, append));
        }
        char[] padding = new char[append];
        char[] padChars = appendStr.toCharArray();
        for (int i = 0; i < append; ++i) {
            padding[i] = padChars[i % appendStrLen];
        }
        return str.concat(new String(padding));
    }
}

