/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.StringUtil;
import java.awt.Color;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtil {
    public static final String NUMBER = "0123456789";
    public static final String LOWER_CASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPER_CASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LOWER_UPPER_CASE_NUMBER = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final int RGB_LIMIT = 256;

    private RandomUtil() {
    }

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static int randomInt() {
        return RandomUtil.randomInt(0, Integer.MAX_VALUE);
    }

    public static int randomInt(int max) {
        return RandomUtil.randomInt(0, max);
    }

    public static int randomInt(int min, int max) {
        return RandomUtil.getRandom().nextInt(min, max);
    }

    public static boolean randomBoolean() {
        return RandomUtil.getRandom().nextBoolean();
    }

    public static String randomString(int length) {
        return RandomUtil.randomString(length, LOWER_UPPER_CASE_NUMBER);
    }

    public static String randomString(int length, String str) {
        if (length <= 0 || StringUtil.isEmpty(str)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int randomLength = str.length();
        for (int i = 0; i < length; ++i) {
            int index = RandomUtil.randomInt(randomLength);
            sb.append(str.charAt(index));
        }
        return sb.toString();
    }

    public static long randomLong() {
        return RandomUtil.randomLong(0L, Long.MAX_VALUE);
    }

    public static long randomLong(long max) {
        return RandomUtil.randomLong(0L, max);
    }

    public static long randomLong(long min, long max) {
        return RandomUtil.getRandom().nextLong(min, max);
    }

    public static Color randomColor() {
        return new Color(RandomUtil.randomInt(256), RandomUtil.randomInt(256), RandomUtil.randomInt(256));
    }
}

