/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.LocalDateTimeUtil;
import cn.nxtools.common.base.Preconditions;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class LocalTimeUtil {
    private LocalTimeUtil() {
    }

    public static String toString(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        return localTime.format(LocalDateTimeUtil.HH_MM_SS);
    }

    public static String toString(LocalTime localTime, DateTimeFormatter formatter) {
        if (localTime == null) {
            return null;
        }
        Preconditions.checkNotNull(formatter);
        return localTime.format(formatter);
    }

    public static String toString(LocalTime localTime, String format) {
        if (localTime == null) {
            return null;
        }
        Preconditions.checkNotNull(format);
        return localTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static LocalTime ofString(String str, DateTimeFormatter formatter) {
        if (str == null) {
            return null;
        }
        Preconditions.checkNotNull(formatter);
        return LocalTime.parse(str, formatter);
    }

    public static LocalTime ofString(String str, String format) {
        if (str == null) {
            return null;
        }
        Preconditions.checkNotNull(format);
        return LocalTime.parse(str, DateTimeFormatter.ofPattern(format));
    }

    public static LocalTime now() {
        return LocalTime.now();
    }

    public static LocalTime now(ZoneId zoneId) {
        return LocalTime.now(zoneId);
    }
}

