/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.LocalDateTimeUtil;
import cn.nxtools.common.base.Preconditions;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class LocalDateUtil {
    private LocalDateUtil() {
    }

    public static String toString(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return localDate.format(LocalDateTimeUtil.YYYY_MM_DD);
    }

    public static String toString(LocalDate localDate, DateTimeFormatter formatter) {
        if (localDate == null) {
            return null;
        }
        Preconditions.checkNotNull(formatter);
        return localDate.format(formatter);
    }

    public static String toString(LocalDate localDate, String format) {
        if (localDate == null) {
            return null;
        }
        Preconditions.checkNotNull(format);
        return localDate.format(DateTimeFormatter.ofPattern(format));
    }

    public static LocalDate ofString(String str, DateTimeFormatter formatter) {
        if (str == null) {
            return null;
        }
        Preconditions.checkNotNull(formatter);
        return LocalDate.parse(str, formatter);
    }

    public static LocalDate ofString(String str, String format) {
        if (str == null) {
            return null;
        }
        Preconditions.checkNotNull(format);
        return LocalDate.parse(str, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDate now() {
        return LocalDate.now();
    }

    public static LocalDate now(ZoneId zoneId) {
        return LocalDate.now(zoneId);
    }
}

