/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.base.Objects;
import cn.nxtools.common.base.Preconditions;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class LocalDateTimeUtil {
    public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter HH_MM_SS = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_SSS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateTimeFormatter YYYY_MM_DD_FORMAT = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_FORMAT = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_SSS_FORMAT = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS");
    public static final DateTimeFormatter YYYYMMDD = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter YYYYMMDDHHMMSS = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final DateTimeFormatter YYYYMMDDHHMMSSSSS = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");

    private LocalDateTimeUtil() {
    }

    public static long currentTimeMillis() {
        Instant instant = Instant.now();
        return instant.toEpochMilli();
    }

    public static long currentTimeSecond() {
        return LocalDateTimeUtil.currentTimeMillis() / 1000L;
    }

    public static LocalDateTime ofMillis(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime ofMillis(long timestamp, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    public static LocalDateTime ofSecond(long timestamp) {
        Instant instant = Instant.ofEpochSecond(timestamp);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime ofSecond(long timestamp, ZoneId zoneId) {
        Instant instant = Instant.ofEpochSecond(timestamp);
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    public static String toString(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return localDateTime.format(YYYY_MM_DD_HH_MM_SS);
    }

    public static String toString(LocalDateTime localDateTime, DateTimeFormatter formatter) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        if (Objects.isNull(formatter)) {
            formatter = YYYY_MM_DD_HH_MM_SS;
        }
        return localDateTime.format(formatter);
    }

    public static String toString(LocalDateTime localDateTime, String format) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        Preconditions.checkNotNull(format);
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static LocalDateTime ofString(String str, DateTimeFormatter formatter) {
        if (Objects.isNull(str)) {
            return null;
        }
        Preconditions.checkNotNull(formatter);
        return LocalDateTime.parse(str, formatter);
    }

    public static LocalDateTime ofString(String str, String format) {
        if (Objects.isNull(str)) {
            return null;
        }
        Preconditions.checkNotNull(format);
        return LocalDateTime.parse(str, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime now(ZoneId zoneId) {
        return LocalDateTime.now(zoneId);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDateTime localDateTime, ZoneId zoneId) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return LocalDateTimeUtil.toDate(localDateTime, ZoneId.systemDefault(), zoneId);
    }

    public static Date toDate(LocalDateTime localDateTime, ZoneId dateTimeZoneId, ZoneId zoneId) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        Preconditions.checkNotNull(dateTimeZoneId);
        Preconditions.checkNotNull(zoneId);
        ZonedDateTime zonedDateTime = localDateTime.atZone(dateTimeZoneId);
        return new Date(zonedDateTime.withZoneSameInstant(zoneId).toLocalDateTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static LocalDateTime ofDate(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime ofDate(Date date, ZoneId zoneId) {
        if (Objects.isNull(date)) {
            return null;
        }
        Preconditions.checkNotNull(zoneId);
        return LocalDateTime.ofInstant(date.toInstant(), zoneId);
    }

    public static long toMillis(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.toMillis(localDateTime, null);
    }

    public static long toMillis(LocalDateTime localDateTime, ZoneId zoneId) {
        Preconditions.checkNotNull(localDateTime);
        zoneId = zoneId == null ? ZoneOffset.systemDefault() : zoneId;
        return localDateTime.atZone(zoneId).toInstant().toEpochMilli();
    }

    public static long toSecond(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.toMillis(localDateTime) / 1000L;
    }

    public static long toSecond(LocalDateTime localDateTime, ZoneId zoneId) {
        return LocalDateTimeUtil.toMillis(localDateTime, zoneId) / 1000L;
    }

    public static LocalDateTime beginOfDay(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return localDateTime.with(LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return localDateTime.with(LocalTime.MAX);
    }
}

