/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.LocalDateTimeUtil;
import cn.nxtools.common.exception.JsonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class JsonUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtil() {
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static String toString(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("json obj to string error", e);
        }
    }

    public static <T> T toObj(String str, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(str, clazz);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("string to object error", e);
        }
    }

    public static <T> T toObj(String str, TypeReference<T> reference) {
        try {
            return (T)objectMapper.readValue(str, reference);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("string to object error", e);
        }
    }

    public static JsonNode readNode(String str) {
        try {
            return objectMapper.readTree(str);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("string to jsonNode error", e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(LocalDateTimeUtil.YYYY_MM_DD_HH_MM_SS_SSS));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(LocalDateTimeUtil.YYYY_MM_DD_HH_MM_SS_SSS));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(LocalDateTimeUtil.YYYY_MM_DD));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(LocalDateTimeUtil.YYYY_MM_DD));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(LocalDateTimeUtil.HH_MM_SS));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(LocalDateTimeUtil.HH_MM_SS));
        objectMapper.registerModule((Module)javaTimeModule);
    }
}

