/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.CollectionUtil;
import cn.nxtools.common.StringUtil;
import cn.nxtools.common.base.Objects;
import cn.nxtools.common.base.Preconditions;
import cn.nxtools.common.exception.IORuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOUtil {
    private static final Logger logger = Logger.getLogger(IOUtil.class.getName());
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final String LINE_SEPARATOR;

    private IOUtil() {
    }

    public static void closeQuietly(Closeable closeable) {
        if (Objects.nonNull(closeable)) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "exception thrown when closing " + closeable, e);
            }
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (Objects.isNull(closeables)) {
            return;
        }
        for (Closeable closeable : closeables) {
            IOUtil.closeQuietly(closeable);
        }
    }

    public static void close(URLConnection conn) {
        if (Objects.isNull(conn)) {
            return;
        }
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    public static void close(Closeable closeable) throws IOException {
        if (Objects.nonNull(closeable)) {
            closeable.close();
        }
    }

    public static void close(Closeable ... closeables) throws IOException {
        if (Objects.isNull(closeables)) {
            return;
        }
        for (Closeable closeable : closeables) {
            IOUtil.close(closeable);
        }
    }

    public static byte[] toByteArray(InputStream inputStream) {
        Preconditions.checkNotNull(inputStream);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int n = 0;
        try {
            while (-1 != (n = inputStream.read(buffer))) {
                output.write(buffer, 0, n);
            }
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static byte[] toByteArray(InputStream inputStream, long size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + size);
        }
        return IOUtil.toByteArray(inputStream, (int)size);
    }

    public static byte[] toByteArray(InputStream inputStream, int size) {
        Preconditions.checkNotNull(inputStream);
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero " + size);
        }
        byte[] buffer = new byte[size];
        try {
            int offset;
            int n = 0;
            for (offset = 0; offset < size && (n = inputStream.read(buffer, offset, size - offset)) != -1; offset += n) {
            }
            if (offset != size) {
                throw new IORuntimeException("Unexpected readed size. current: " + offset + ", excepted: " + size);
            }
            return buffer;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static byte[] toByteArray(Reader reader) throws IOException {
        Preconditions.checkNotNull(reader);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(reader, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader reader, String encoding) throws IOException {
        Preconditions.checkNotNull(reader);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(reader, (OutputStream)output, encoding);
        return output.toByteArray();
    }

    public static void copy(Reader reader, OutputStream output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtil.copy(reader, out);
        out.flush();
    }

    public static void copy(Reader reader, OutputStream output, String encoding) throws IOException {
        if (Objects.isNull(encoding)) {
            IOUtil.copy(reader, output);
        } else {
            OutputStreamWriter out = new OutputStreamWriter(output, encoding);
            IOUtil.copy(reader, out);
            out.flush();
        }
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        char[] chars = new char[8192];
        int n = 0;
        long count = 0L;
        while (-1 != (n = reader.read(chars))) {
            writer.write(chars, 0, n);
            count += (long)n;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(FileInputStream in, FileOutputStream out) {
        long l;
        Preconditions.checkNotNull(in, "FileInputStream cannot be null");
        Preconditions.checkNotNull(out, "FileOutputStream cannot be null");
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = in.getChannel();
            outChannel = out.getChannel();
            l = IOUtil.copy(inChannel, outChannel);
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(inChannel, outChannel);
            throw throwable;
        }
        IOUtil.closeQuietly(inChannel, outChannel);
        return l;
    }

    public static long copy(InputStream in, OutputStream out) {
        return IOUtil.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) {
        Preconditions.checkNotNull(in, "InputStream cannot be null");
        Preconditions.checkNotNull(out, "OutputStream cannot be null");
        bufferSize = bufferSize <= 0 ? 8192 : bufferSize;
        try {
            int n;
            long count = 0L;
            byte[] buffer = new byte[bufferSize];
            while (-1 != (n = in.read(buffer))) {
                out.write(buffer, 0, n);
                count += (long)n;
            }
            return count;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(FileInputStream in, FileOutputStream out, int bufferSize) {
        long l;
        Preconditions.checkNotNull(in, "FileInputStream cannot be null");
        Preconditions.checkNotNull(out, "FileOutputStream cannot be null");
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = in.getChannel();
            outChannel = out.getChannel();
            l = IOUtil.copy(inChannel, outChannel, bufferSize);
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(inChannel, outChannel);
            throw throwable;
        }
        IOUtil.closeQuietly(inChannel, outChannel);
        return l;
    }

    public static long copy(FileChannel inChannel, FileChannel outChannel, int bufferSize) {
        Preconditions.checkNotNull(inChannel, "FileChannel in cannot be null");
        Preconditions.checkNotNull(outChannel, "FileChannel out cannot be null");
        bufferSize = bufferSize < 0 ? 8192 : bufferSize;
        try {
            long pos;
            long size = inChannel.size();
            long count = 0L;
            for (pos = 0L; pos < size; pos += outChannel.transferFrom(inChannel, pos, count)) {
                count = size - pos > (long)bufferSize ? (long)bufferSize : size - pos;
            }
            return pos;
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    public static long copy(FileChannel inChannel, FileChannel outChannel) {
        Preconditions.checkNotNull(inChannel, "FileChannel in cannot be null");
        Preconditions.checkNotNull(outChannel, "FileChannel out cannot be null");
        try {
            return inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    public static void write(String data, OutputStream output) {
        if (Objects.isNull(data)) {
            return;
        }
        try {
            output.write(data.getBytes());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void write(String data, OutputStream output, String encoding) {
        if (Objects.isNull(data)) {
            return;
        }
        if (StringUtil.isEmpty(encoding)) {
            IOUtil.write(data, output);
        } else {
            try {
                output.write(data.getBytes(encoding));
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static void writeLines(Collection<?> lines, OutputStream output, String encoding, String lineEnding) {
        if (CollectionUtil.isEmpty(lines)) {
            return;
        }
        if (Objects.isNull(encoding)) {
            IOUtil.writeLinesForLineEnding(lines, output, lineEnding);
            return;
        }
        if (StringUtil.isEmpty(lineEnding)) {
            lineEnding = LINE_SEPARATOR;
        }
        for (Object line : lines) {
            try {
                if (Objects.nonNull(line)) {
                    output.write(line.toString().getBytes(encoding));
                }
                output.write(lineEnding.getBytes(encoding));
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static void writeLines(Collection<?> lines, OutputStream output, String encoding) {
        IOUtil.writeLines(lines, output, encoding, null);
    }

    public static void writeLines(Collection<?> lines, OutputStream output) {
        IOUtil.writeLines(lines, output, null);
    }

    private static void writeLinesForLineEnding(Collection<?> lines, OutputStream output, String lineEnding) {
        if (CollectionUtil.isEmpty(lines)) {
            return;
        }
        if (Objects.isNull(lineEnding)) {
            lineEnding = LINE_SEPARATOR;
        }
        for (Object line : lines) {
            try {
                if (Objects.nonNull(line)) {
                    output.write(line.toString().getBytes());
                }
                output.write(lineEnding.getBytes());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static String toString(InputStream inputStream, String encoding) {
        InputStreamReader reader = null;
        StringWriter writer = new StringWriter();
        try {
            reader = Objects.isNull(encoding) ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, encoding);
            char[] buffer = new char[8192];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtil.closeQuietly((Closeable)reader);
        if (writer != null) {
            return writer.toString();
        }
        return null;
    }

    public static String toString(InputStream inputStream) {
        return IOUtil.toString(inputStream, null);
    }

    public static void flushQuietly(Flushable flushable) {
        if (Objects.nonNull(flushable)) {
            try {
                flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        StringWriter buf = new StringWriter();
        PrintWriter out = new PrintWriter(buf);
        out.println();
        LINE_SEPARATOR = buf.toString();
        out.close();
    }
}

