/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.base.Objects;

public class FilenameUtil {
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final int NOT_FOUND = -1;

    private FilenameUtil() {
    }

    public static String getExtension(String filename) {
        if (Objects.isNull(filename)) {
            return null;
        }
        int i = filename.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return filename.substring(i + 1);
    }

    public static String getName(String filename) {
        if (Objects.isNull(filename)) {
            return null;
        }
        int i = FilenameUtil.indexOfLastSeparator(filename);
        if (i == -1) {
            return "";
        }
        return filename.substring(i + 1);
    }

    public static int indexOfLastSeparator(String filename) {
        if (Objects.isNull(filename)) {
            return -1;
        }
        int unix = filename.lastIndexOf(47);
        int windows = filename.lastIndexOf(92);
        return Math.max(unix, windows);
    }

    public static String getBaseName(String filename) {
        String name = FilenameUtil.getName(filename);
        if (Objects.isNull(name)) {
            return null;
        }
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }
}

