/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.IOUtil;
import cn.nxtools.common.base.Objects;
import cn.nxtools.common.base.Preconditions;
import cn.nxtools.common.exception.FileException;
import cn.nxtools.common.exception.IORuntimeException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;

public class FileUtil {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;

    private FileUtil() {
    }

    public static void moveFile(File source, File target) {
        Preconditions.checkNotNull(source, "Source must not be null");
        Preconditions.checkNotNull(target, "Target must not be null");
        if (!source.exists()) {
            throw new FileException("Source " + source + " not exist");
        }
        if (source.isDirectory()) {
            throw new FileException("Source " + source + " is a directory");
        }
        if (target.exists()) {
            throw new FileException("Target file " + target + " already exist");
        }
        boolean isSame = FileUtil.equalsCanonicalPath(source, target);
        if (isSame) {
            throw new FileException("Source " + source + " and target " + target + " are the same");
        }
        boolean flag = source.renameTo(target);
        if (!flag) {
            FileUtil.copyFile(source, target);
            if (!source.delete()) {
                target.delete();
                throw new FileException("Failed to delete source file " + source + " after copying file" + target);
            }
        }
    }

    public static void moveDirectory(File source, File target) {
        Preconditions.checkNotNull(source, "Source must not be null");
        Preconditions.checkNotNull(target, "Target must not be null");
        if (!source.exists()) {
            throw new FileException("Source " + source + " not exist");
        }
        if (!source.isDirectory()) {
            throw new FileException("Source " + source + " is not a directory");
        }
        if (target.exists()) {
            throw new FileException("Target " + target + " already exist");
        }
        boolean isSame = FileUtil.equalsCanonicalPath(source, target);
        if (isSame) {
            throw new FileException("Source " + source + " and target " + target + " are the same");
        }
        boolean flag = source.renameTo(target);
        if (!flag) {
            FileUtil.copyDirectory(source, target);
            if (!FileUtil.deleteQuietly(source)) {
                FileUtil.deleteQuietly(target);
                throw new FileException("Failed to delete source directory " + source + " after copying directory" + target);
            }
        }
    }

    public static void moveFileToDirectory(File source, File target) {
        Preconditions.checkNotNull(source, "Source must not be null");
        Preconditions.checkNotNull(target, "Target must not be null");
        if (!source.exists()) {
            throw new FileException("Source " + source + " not exist");
        }
        if (source.isDirectory()) {
            throw new FileException("Source " + source + " exist but is a directory");
        }
        if (target.exists() && !target.isDirectory()) {
            throw new FileException("Target " + target + " exist but is a file");
        }
        FileUtil.moveFile(source, new File(target, source.getName()));
    }

    public static void moveToDirectory(File source, File target) {
        Preconditions.checkNotNull(source, "Source must not be null");
        Preconditions.checkNotNull(target, "Target must not be null");
        if (!source.exists()) {
            throw new FileException("Source " + source + " not exist");
        }
        if (source.isDirectory()) {
            FileUtil.moveDirectoryToDirectory(source, target);
        } else {
            FileUtil.moveFileToDirectory(source, target);
        }
    }

    public static void moveDirectoryToDirectory(File source, File target) {
        Preconditions.checkNotNull(source, "Source must not be null");
        Preconditions.checkNotNull(target, "Target must not be null");
        if (!source.exists()) {
            throw new FileException("Source " + source + " not exist");
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        if (!target.exists()) {
            throw new FileException(target + " directory cannot be created");
        }
        if (!target.isDirectory()) {
            throw new FileException(target + " is not a directory");
        }
        FileUtil.moveDirectory(source, new File(target, source.getName()));
    }

    public static void copyFile(File source, File target) {
        Preconditions.checkNotNull(source, "Source must not be null");
        Preconditions.checkNotNull(target, "Target must not be null");
        if (!source.exists()) {
            throw new FileException("Source " + source + " not exist");
        }
        if (source.isDirectory()) {
            throw new FileException("Source " + source + " is a directory");
        }
        boolean isSame = FileUtil.equalsCanonicalPath(source, target);
        if (isSame) {
            throw new FileException("Source " + source + " and target " + target + " are the same");
        }
        File parentFile = target.getParentFile();
        if (!parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new FileException(parentFile + " directory cannot be created");
        }
        FileUtil.doCopyFile(source, target);
    }

    public static void copyDirectory(File source, File target) {
        Preconditions.checkNotNull(source, "Source must not be null");
        Preconditions.checkNotNull(target, "Target must not be null");
        if (!source.exists()) {
            throw new FileException("Source " + source + " not exist");
        }
        if (!source.isDirectory()) {
            throw new FileException("Source " + source + " exist but is not a directory");
        }
        boolean isSame = FileUtil.equalsCanonicalPath(source, target);
        if (isSame) {
            throw new FileException("Source " + source + " and target " + target + " are the same");
        }
        FileUtil.doCopyDirectory(source, target);
    }

    public static boolean deleteQuietly(File file) {
        if (Objects.isNull(file) || !file.exists()) {
            return true;
        }
        try {
            if (file.isDirectory()) {
                FileUtil.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean cleanDirectory(File directory) {
        if (Objects.isNull(directory) || !directory.exists()) {
            return true;
        }
        if (!directory.isDirectory()) {
            throw new FileException("clean " + directory + " is not a directory");
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return true;
        }
        boolean flag = false;
        for (File file : files) {
            flag |= !FileUtil.deleteQuietly(file);
        }
        return !flag;
    }

    public static boolean equalsCanonicalPath(File file1, File file2) {
        Preconditions.checkNotNull(file1, "file1 must not be null");
        Preconditions.checkNotNull(file2, "file2 must not be null");
        return FileUtil.getCanonicalPath(file1).equals(FileUtil.getCanonicalPath(file2));
    }

    public static void copyFileToDirectory(File source, File target) {
        Preconditions.checkNotNull(source, "Source must not be null");
        Preconditions.checkNotNull(target, "Target must not be null");
        if (target.exists() && !target.isDirectory()) {
            throw new FileException("Target " + target + " exist but is not a directory");
        }
        FileUtil.copyFile(source, new File(target, source.getName()));
    }

    public static void copyDirectoryToDirectory(File source, File target) {
        Preconditions.checkNotNull(source, "Source must not be null");
        Preconditions.checkNotNull(target, "Target must not be null");
        if (target.exists() && !target.isDirectory()) {
            throw new FileException("Target " + target + " exist but is not a directory");
        }
        FileUtil.copyDirectory(source, new File(target, source.getName()));
    }

    public static FileOutputStream openOutputStream(File file, boolean append) {
        Preconditions.checkNotNull(file, "File " + file + " must not be null");
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new FileException("File " + file + " exist but is a directory");
            }
            if (!file.canWrite()) {
                throw new FileException("File " + file + " cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new FileException("Directory " + parent + " could not be created");
            }
        }
        try {
            return new FileOutputStream(file, append);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void writeString(String data, File file, String encoding) {
        FileUtil.writeString(data, file, false, encoding);
    }

    public static void writeString(String data, File file, boolean append) {
        FileUtil.writeString(data, file, append, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(String data, File file, boolean append, String encoding) {
        FileOutputStream output = null;
        try {
            output = FileUtil.openOutputStream(file, append);
            IOUtil.write(data, output, encoding);
        }
        finally {
            IOUtil.closeQuietly((Closeable)output);
        }
    }

    public static void write(CharSequence data, File file, boolean append, String encoding) {
        String str = Objects.isNull(data) ? null : data.toString();
        FileUtil.writeString(str, file, append, encoding);
    }

    public static void write(CharSequence data, File file, boolean append) {
        FileUtil.write(data, file, append, null);
    }

    public static void write(CharSequence data, File file, String encoding) {
        FileUtil.write(data, file, false, encoding);
    }

    public static void write(CharSequence data, File file) {
        FileUtil.write(data, file, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(Collection<?> data, File file, boolean append, String encoding, String lineEnding) {
        FileOutputStream output = null;
        try {
            output = FileUtil.openOutputStream(file, append);
            IOUtil.writeLines(data, output, encoding, lineEnding);
        }
        finally {
            IOUtil.closeQuietly((Closeable)output);
        }
    }

    public static void writeLines(Collection<?> data, File file, boolean append, String encoding) {
        FileUtil.writeLines(data, file, append, encoding, null);
    }

    public static void writeLines(Collection<?> data, File file, boolean append) {
        FileUtil.writeLines(data, file, append, null, null);
    }

    public static void writeLines(Collection<?> data, File file) {
        FileUtil.writeLines(data, file, false, null, null);
    }

    public static void writeLines(Collection<?> data, File file, String encoding) {
        FileUtil.writeLines(data, file, false, encoding, null);
    }

    public static void write(byte[] data, File file, boolean append) {
        FileOutputStream output = null;
        try {
            output = FileUtil.openOutputStream(file, append);
            ((OutputStream)output).write(data);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)output);
        }
    }

    public static void write(byte[] data, File file) {
        FileUtil.write(data, file, false);
    }

    public static FileInputStream openInputStream(File file) {
        Preconditions.checkNotNull(file, "File " + file + " must not be null");
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new FileException("File " + file + " exist but is a directory");
            }
            if (!file.canRead()) {
                throw new FileException("File " + file + " cannot be read");
            }
        } else {
            throw new FileException("File " + file + " not exist");
        }
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file) {
        FileInputStream in = null;
        try {
            byte[] bytes;
            in = FileUtil.openInputStream(file);
            byte[] byArray = bytes = IOUtil.toByteArray((InputStream)in, file.length());
            return byArray;
        }
        finally {
            IOUtil.closeQuietly((Closeable)in);
        }
    }

    public static String readFileToString(File file) {
        return FileUtil.readFileToString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String encoding) {
        FileInputStream in = null;
        try {
            in = FileUtil.openInputStream(file);
            String string = IOUtil.toString(in, encoding);
            return string;
        }
        finally {
            IOUtil.closeQuietly((Closeable)in);
        }
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream readFileToInputStream(File file) {
        FileInputStream in = FileUtil.openInputStream(file);
        return in;
    }

    public static boolean isSub(File parent, File sub) {
        Preconditions.checkNotNull(parent, "Parent File must be not null");
        Preconditions.checkNotNull(sub, "Sub File must be not null");
        return FileUtil.isSub(parent.toPath(), sub.toPath());
    }

    public static boolean isSub(Path parent, Path sub) {
        return sub.toAbsolutePath().normalize().startsWith(parent.toAbsolutePath().normalize());
    }

    private static void doCopyFile(File source, File target) {
        if (target.exists() && !target.canWrite()) {
            throw new FileException("Target " + target + " exist but cannot be written to");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target);
            IOUtil.copy(fis, fos);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fis, fos);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(fis, fos);
        if (source.length() != target.length()) {
            throw new FileException("Failed to copy full contents from " + source + " to " + target);
        }
    }

    private static void doCopyDirectory(File source, File target) {
        File[] files = source.listFiles();
        if (files == null) {
            return;
        }
        if (target.exists()) {
            if (!target.isDirectory()) {
                throw new FileException("Target " + target + " exist but is not a directory");
            }
        } else if (!target.mkdirs() && !target.isDirectory()) {
            throw new FileException("Target " + target + " directory cannot be created");
        }
        if (!target.canWrite()) {
            throw new FileException("Target " + target + " cannot be written to");
        }
        for (File file : files) {
            File tgtFile = new File(target, file.getName());
            if (file.isDirectory()) {
                FileUtil.doCopyDirectory(file, tgtFile);
                continue;
            }
            FileUtil.doCopyFile(file, tgtFile);
        }
    }
}

